/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.templates;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.templates.DeleteTemplateAction;
import ch.transsoft.edec.ui.gui.templates.RenameTemplateAction;
import ch.transsoft.edec.ui.pm.templates.FileNode;
import ch.transsoft.edec.ui.pm.templates.TemplateModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;

public class TemplatePanel
extends DefaultPanel {
    private JTree tree;
    private TemplateModel model = Services.get(IGuiService.class).getTemplateModel();

    public TemplatePanel() {
        this.createTree();
    }

    private void addTreeListener() {
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() != 2) {
                    return;
                }
                TreePath path = TemplatePanel.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                FileNode fileNode = (FileNode)path.getLastPathComponent();
                File file = fileNode.getFile();
                if (!file.exists()) {
                    return;
                }
                if (file.isDirectory()) {
                    return;
                }
                Services.get(IAppService.class).requestOpenTemplate(file);
            }
        });
    }

    private void createTree() {
        this.setLayout(new MigLayout("fill", "0[fill]0", "0[50]0[grow, fill]0"));
        this.add((Component)new Label(String.format("<html><h2>%s</h2></html>", Services.getText(1526))), "gapx 5, wrap");
        this.tree = new JTree(this.model);
        this.addTreeListener();
        this.add(new JScrollPane(this.tree));
        this.addPopupMenu();
    }

    private void addPopupMenu() {
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                TreePath path = TemplatePanel.this.tree.getPathForLocation(e2.getX(), e2.getY());
                if (path == null) {
                    return;
                }
                TemplatePanel.this.tree.setSelectionPath(path);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (e2.getButton() == 3) {
                    TemplatePanel.this.showMenu(e2);
                }
            }
        });
    }

    private void showMenu(MouseEvent e2) {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        FileNode fileNode = (FileNode)path.getLastPathComponent();
        File file = fileNode.getFile();
        if (!file.isFile()) {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add(new RenameTemplateAction(file, this.model));
        menu.add(new DeleteTemplateAction(file, this.model));
        try {
            menu.show(e2.getComponent(), e2.getX(), e2.getY());
        }
        catch (Exception ex) {
            Services.get(ILoggingService.class).logSilentWithBugMail(ex, "TemplatePanel.showMenu threw.");
        }
    }
}

