/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.index.IArchiveChangeListener;
import ch.transsoft.edec.service.index.bordereau.IBordereauService;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.evvimport.bordereau.BordereauIndexTablePmBase;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.sendinglist.IArchiveSearchPm;
import ch.transsoft.edec.ui.pm.sendinglist.YearItem;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BordereauArchiveTablePm
extends BordereauIndexTablePmBase
implements IPm,
IArchiveSearchPm,
IDisposable {
    private final Map<Integer, BordereauIndex> archive = new LinkedHashMap<Integer, BordereauIndex>();
    private int size = 0;
    private final DefaultComboBoxModel<YearItem> selectedPeriod = new DefaultComboBoxModel();
    private final Disposables disposables = new Disposables();

    public BordereauArchiveTablePm(SimpleDocument searchModel) {
        super(searchModel);
        this.addComboListener();
        this.addListener();
    }

    private void addComboListener() {
        this.selectedPeriod.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                BordereauArchiveTablePm.this.clearArchive();
                YearItem selection = BordereauArchiveTablePm.this.getSelectedYearItem();
                HashSet<Integer> years = new HashSet<Integer>();
                years.add(selection.getYear());
                years.add(selection.getYear() - 1);
                Services.get(IBordereauService.class).readArchive(years);
            }
        });
    }

    private YearItem getSelectedYearItem() {
        return (YearItem)this.selectedPeriod.getSelectedItem();
    }

    private void pupulateCombo() {
        for (int i2 = DateUtil.getCurrentYear(); i2 > 2000; --i2) {
            this.selectedPeriod.addElement(new YearItem(i2));
        }
    }

    public void initialize() {
        this.pupulateCombo();
    }

    private void addListener() {
        this.disposables.add(Services.get(IBordereauService.class).add(new IArchiveChangeListener<BordereauEntry, BordereauIndex>(){

            @Override
            public void changed(int year, BordereauIndex archivePart) {
                YearItem selected = BordereauArchiveTablePm.this.getSelectedYearItem();
                if (selected.getYear() != year && selected.getYear() - 1 != year) {
                    return;
                }
                BordereauArchiveTablePm.this.archive.put(year, archivePart);
                BordereauArchiveTablePm.this.updatesize();
                BordereauArchiveTablePm.this.fireTableDataChangedRestoreSelection();
            }

            @Override
            public void clear() {
                BordereauArchiveTablePm.this.clearArchive();
            }
        }));
    }

    private void clearArchive() {
        this.archive.clear();
        this.updatesize();
        this.fireTableDataChanged();
    }

    private void updatesize() {
        int result = 0;
        for (BordereauIndex current : this.archive.values()) {
            result += current.getEntryList().size();
        }
        this.size = result;
    }

    @Override
    public int getRowCount() {
        return this.size;
    }

    @Override
    public BordereauEntry getIndexEntry(int row) {
        int offset = 0;
        Iterator<BordereauIndex> iterator = this.archive.values().iterator();
        while (iterator.hasNext()) {
            int index = row - offset;
            BordereauIndex current = iterator.next();
            if (index < current.getEntryList().size()) {
                return current.getEntryList().get(index);
            }
            offset += current.getEntryList().size();
        }
        throw Check.fail("index not found: ", row);
    }

    public DefaultComboBoxModel<YearItem> getSelectedPeriod() {
        return this.selectedPeriod;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

