/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.index.IArchiveChangeListener;
import ch.transsoft.edec.service.index.receipt.IReceiptService;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.evvimport.receipt.ReceiptIndexTablePmBase;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.sendinglist.IArchiveSearchPm;
import ch.transsoft.edec.ui.pm.sendinglist.YearItem;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ReceiptArchiveTablePm
extends ReceiptIndexTablePmBase
implements IPm,
IArchiveSearchPm,
IDisposable {
    private final Map<Integer, ReceiptIndex> archive = new LinkedHashMap<Integer, ReceiptIndex>();
    private int size = 0;
    private final DefaultComboBoxModel<YearItem> selectedPeriod = new DefaultComboBoxModel();
    private final Disposables disposables = new Disposables();

    public ReceiptArchiveTablePm(SimpleDocument searchModel) {
        super(searchModel);
        this.addComboListener();
        this.addListener();
    }

    private void addComboListener() {
        this.selectedPeriod.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                ReceiptArchiveTablePm.this.clearArchive();
                YearItem selection = ReceiptArchiveTablePm.this.getSelectedYearItem();
                HashSet<Integer> years = new HashSet<Integer>();
                years.add(selection.getYear());
                years.add(selection.getYear() - 1);
                Services.get(IReceiptService.class).readArchive(years);
            }
        });
    }

    private YearItem getSelectedYearItem() {
        return (YearItem)this.selectedPeriod.getSelectedItem();
    }

    private void pupulateCombo() {
        for (int i2 = DateUtil.getCurrentYear(); i2 > 2000; --i2) {
            this.selectedPeriod.addElement(new YearItem(i2));
        }
    }

    public void initialize() {
        this.pupulateCombo();
    }

    private void addListener() {
        this.disposables.add(Services.get(IReceiptService.class).add(new IArchiveChangeListener<ReceiptEntry, ReceiptIndex>(){

            @Override
            public void changed(int year, ReceiptIndex archivePart) {
                YearItem selected = ReceiptArchiveTablePm.this.getSelectedYearItem();
                if (selected.getYear() != year && selected.getYear() - 1 != year) {
                    return;
                }
                ReceiptArchiveTablePm.this.archive.put(year, archivePart);
                ReceiptArchiveTablePm.this.updatesize();
                ReceiptArchiveTablePm.this.fireTableDataChangedRestoreSelection();
            }

            @Override
            public void clear() {
                ReceiptArchiveTablePm.this.clearArchive();
            }
        }));
    }

    private void clearArchive() {
        this.archive.clear();
        this.updatesize();
        this.fireTableDataChanged();
    }

    private void updatesize() {
        int result = 0;
        for (ReceiptIndex current : this.archive.values()) {
            result += current.getEntryList().size();
        }
        this.size = result;
    }

    @Override
    public int getRowCount() {
        return this.size;
    }

    @Override
    public ReceiptEntry getIndexEntry(int row) {
        int offset = 0;
        Iterator<ReceiptIndex> iterator = this.archive.values().iterator();
        while (iterator.hasNext()) {
            int index = row - offset;
            ReceiptIndex current = iterator.next();
            if (index < current.getEntryList().size()) {
                return current.getEntryList().get(index);
            }
            offset += current.getEntryList().size();
        }
        throw Check.fail("index not found: ", row);
    }

    public DefaultComboBoxModel<YearItem> getSelectedPeriod() {
        return this.selectedPeriod;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

