/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.TableAdapter;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.UpdateOrderNumberJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.option.pm.moduleimp.ImpColDesc;
import ch.transsoft.edec.ui.dialog.option.pm.moduleimp.ImpColDescFactory;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexTablePmListener;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;

public abstract class ReceiptIndexTablePmBase
extends AbstractTableModel {
    private ITableAdapter[] configs;
    private List<ImpColDesc> colDesc;
    private final SimpleDocument searchModel;
    private final ListenerList<IIndexTablePmListener> listeners = new ListenerList();
    private ListSelectionModel selectionModel;

    public ReceiptIndexTablePmBase(SimpleDocument searchModel) {
        this.searchModel = searchModel;
        this.updateStructure();
        this.addSearchListener();
    }

    private ITableAdapter[] getConfigs() {
        ArrayList<TableAdapter> result = new ArrayList<TableAdapter>();
        if (this.isEnabled(1)) {
            result.add(new TableAdapter("vvm", 1451, IntegralNode.class, false));
        }
        if (this.isEnabled(2)) {
            result.add(new TableAdapter("vvz", 1450, IntegralNode.class, false));
        }
        if (this.isEnabled(3)) {
            result.add(new TableAdapter("rbm", 1453, IntegralNode.class, false));
        }
        if (this.isEnabled(4)) {
            result.add(new TableAdapter("rbz", 1452, IntegralNode.class, false));
        }
        if (this.isEnabled(5)) {
            result.add(new TableAdapter("date", 1454, StringNode.class, false));
        }
        if (this.isEnabled(6)) {
            result.add(new TableAdapter("customsReferenceNumber", 1462, StringNode.class, false));
        }
        if (this.isEnabled(7)) {
            result.add(new TableAdapter("customsOffice", 1473, StringNode.class, false));
        }
        if (this.isEnabled(8)) {
            result.add(new TableAdapter("declarant", 1472, StringNode.class, false));
        }
        if (this.isEnabled(26)) {
            result.add(new TableAdapter("traderReference", 1489, StringNode.class, false));
        }
        if (this.isEnabled(9)) {
            result.add(new TableAdapter("importer", 1475, StringNode.class, false));
        }
        if (this.isEnabled(23)) {
            result.add(new TableAdapter("importerReference", 1486, StringNode.class, false));
        }
        if (this.isEnabled(29)) {
            result.add(new TableAdapter("importerUid", 1600, String.class, false));
        }
        if (this.isEnabled(10)) {
            result.add(new TableAdapter("consignee", 1474, StringNode.class, false));
        }
        if (this.isEnabled(25)) {
            result.add(new TableAdapter("consigneeReference", 1487, StringNode.class, false));
        }
        if (this.isEnabled(28)) {
            result.add(new TableAdapter("consigneeUid", 1447, String.class, false));
        }
        if (this.isEnabled(11)) {
            result.add(new TableAdapter("consigneeCity", 1469, StringNode.class, false));
        }
        if (this.isEnabled(12)) {
            result.add(new TableAdapter("consigneeCountry", 1470, StringNode.class, false));
        }
        if (this.isEnabled(22)) {
            result.add(new TableAdapter("permitAuthority", 1483, StringNode.class, false));
        }
        if (this.isEnabled(21)) {
            result.add(new TableAdapter("permitNumber", 1482, StringNode.class, false));
        }
        if (this.isEnabled(13)) {
            result.add(new TableAdapter("totalVAT", 1478, DecimalNode.class, false));
        }
        if (this.isEnabled(14)) {
            result.add(new TableAdapter("totalDuty", 1479, DecimalNode.class, false));
        }
        if (this.isEnabled(20)) {
            result.add(new TableAdapter("preference", 1481, StringNode.class, false));
        }
        if (this.isEnabled(30)) {
            result.add(new TableAdapter("monopol", 1700, DecimalNode.class, false));
        }
        if (this.isEnabled(31)) {
            result.add(new TableAdapter("customsClearanceType", 1701, StringNode.class, false));
        }
        if (this.isEnabled(15)) {
            result.add(new TableAdapter("consignorName", 1468, StringNode.class, false));
        }
        if (this.isEnabled(24)) {
            result.add(new TableAdapter("consignorReference", 1488, StringNode.class, false));
        }
        if (this.isEnabled(16)) {
            result.add(new TableAdapter("consignorCity", 1469, StringNode.class, false));
        }
        if (this.isEnabled(17)) {
            result.add(new TableAdapter("consignorCountry", 1470, StringNode.class, false));
        }
        if (this.isEnabled(18)) {
            result.add(new TableAdapter("bordereauNumberWithSourceInfo", 1461, StringNode.class, false));
        }
        if (this.isEnabled(19)) {
            result.add(new TableAdapter("orderNumber", 1477, StringNode.class, 100, true));
        }
        if (this.isEnabled(27)) {
            result.add(new TableAdapter("star", 1490, Boolean.class, 30, false));
        }
        return result.toArray(new ITableAdapter[result.size()]);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    protected void fireTableDataChangedRestoreSelection() {
        if (this.selectionModel == null) {
            this.fireTableDataChanged();
            return;
        }
        int currentSelection = this.selectionModel.getLeadSelectionIndex();
        this.fireTableDataChanged();
        if (this.getRowCount() == 0) {
            return;
        }
        currentSelection = currentSelection > this.getRowCount() - 1 ? this.getRowCount() - 1 : currentSelection;
        try {
            this.selectionModel.setSelectionInterval(currentSelection, currentSelection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isEnabled(int id) {
        for (ImpColDesc desc : this.getColDescs()) {
            if (desc.getIntId() != id) continue;
            return desc.isEnabled();
        }
        throw Check.fail("No ImportColDescXml for id " + id);
    }

    private List<ImpColDesc> getColDescs() {
        return this.colDesc;
    }

    @Override
    public void fireTableStructureChanged() {
        this.updateStructure();
        super.fireTableStructureChanged();
    }

    private void updateStructure() {
        this.colDesc = ImpColDescFactory.getColDescs(Services.get(IConfigService.class).getOptionInfo().getModuleImportInfo());
        this.configs = this.getConfigs();
    }

    public void addSearchListener() {
        this.searchModel.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                ReceiptIndexTablePmBase.this.notifySearchTextChanged(ReceiptIndexTablePmBase.this.searchModel.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                ReceiptIndexTablePmBase.this.notifySearchTextChanged(ReceiptIndexTablePmBase.this.searchModel.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
    }

    public void notifySearchNext(boolean backwards) {
        for (IIndexTablePmListener listener : this.listeners) {
            listener.searchNext(backwards);
        }
    }

    public void setSearchText(String text) {
        this.searchModel.setText(text);
    }

    public void clearSearch() {
        this.searchModel.setText("");
    }

    private void notifySearchTextChanged(String text) {
        for (IIndexTablePmListener listener : this.listeners) {
            listener.searchTextChanged(text);
        }
    }

    public void notifyOpenCurrentSending() {
        for (IIndexTablePmListener listener : this.listeners) {
            listener.openCurrentSending();
        }
    }

    @Override
    public int getColumnCount() {
        return this.configs.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.configs[columnIndex].getColType();
    }

    @Override
    public String getColumnName(int column) {
        return this.configs[column].getColName();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.configs[columnIndex].isEditable();
    }

    private ImpColDesc getColDescAt(int columnIndex) {
        int index = 0;
        for (ImpColDesc current : this.getColDescs()) {
            if (!current.isEnabled()) continue;
            if (index == columnIndex) {
                return current;
            }
            ++index;
        }
        throw new IllegalStateException("No ImplColDesc for index " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String value;
        String string = value = aValue == null ? "" : aValue.toString();
        if (this.getColDescAt(columnIndex).getIntId() == 19) {
            ReceiptEntry entry = this.getIndexEntry(rowIndex);
            Services.get(IBackendService.class).put(new UpdateOrderNumberJob(entry, value));
        }
    }

    public ITableAdapter[] getConfig() {
        return this.configs;
    }

    @Override
    public INode<?> getValueAt(int rowIndex, int columnIndex) {
        return this.configs[columnIndex].getValue(this.getIndexEntry(rowIndex));
    }

    public abstract ReceiptEntry getIndexEntry(int var1);

    public Document getSearchModel() {
        return this.searchModel;
    }

    public void add(IIndexTablePmListener listener) {
        this.listeners.add(listener);
    }

    public int translateIdToColIndex(int id) {
        int result = 0;
        for (int i2 = 0; i2 < this.getColDescs().size(); ++i2) {
            if (this.getColDescs().get(i2).getIntId() == id) {
                return result;
            }
            if (!this.getColDescs().get(i2).isEnabled()) continue;
            ++result;
        }
        throw Check.fail("No ImportColDescXml for id " + id);
    }

    public boolean idIsVisible(int id) {
        return this.isEnabled(id);
    }
}

