/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.imp;

import ch.transsoft.edec.model.infra.InjectionSpec;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNodeBase;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.masterdata.Currency;
import ch.transsoft.edec.model.masterdata.GoodsItems;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.gui.imp.ImportTable;
import ch.transsoft.edec.ui.pm.imp.SendingInfo;
import ch.transsoft.edec.ui.pm.imp.table.ImportTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;

public class ImportModel {
    private final ImportTable table;
    private final ImportTableModel importTableModel = new ImportTableModel();
    private final DefaultListSelectionModel selectionModel;

    public ImportModel() {
        this.table = new ImportTable(this);
        this.selectionModel = new DefaultListSelectionModel();
        this.table.setSelectionModel(this.selectionModel);
    }

    public ImportTable getTable() {
        return this.table;
    }

    public ImportTableModel getImportTableModel() {
        return this.importTableModel;
    }

    public void refresh(boolean force) {
        this.importTableModel.refresh(force);
    }

    public void openSelectedSendings() {
    }

    public void importSendings() {
        int min = this.selectionModel.getMinSelectionIndex();
        int max = this.selectionModel.getMaxSelectionIndex();
        ArrayList<Sending> result = new ArrayList<Sending>();
        for (int i2 = min; i2 <= max; ++i2) {
            SendingInfo sendingInfo;
            if (!this.selectionModel.isSelectedIndex(i2) || (sendingInfo = this.getByIndex(i2)).hasError()) continue;
            result.add(sendingInfo.getSending());
        }
        if (result.isEmpty()) {
            return;
        }
        Sending sending = Services.get(IAppService.class).getCurrentSending();
        if (sending.getState().hasAl()) {
            DialogUtil.showWarningDialog(Services.getText(600), Services.getText(1567));
            return;
        }
        Services.get(IDataService.class).executeOnMasterdata(DataFiles.goodsItem, masterData -> {
            this.importSendings((List<Sending>)result, (GoodsItems)masterData);
            Services.get(IGuiService.class).selectExportTab(GuiService.ExportTab.itemList);
        });
    }

    public SendingInfo getByIndex(int row) {
        return this.importTableModel.getSendingInfo(this.table.convertRowIndexToModel(row));
    }

    private void importSendings(List<Sending> result, GoodsItems masterDatas) {
        this.injectToCurrentSending(result, masterDatas);
        for (Sending current : result) {
            this.importTableModel.markAsImported(current);
        }
    }

    private void injectToCurrentSending(List<Sending> imports, GoodsItems masterDatas) {
        Sending sending = Services.get(IAppService.class).getCurrentSending();
        InjectionSpec spec = this.getInjectionSpec(masterDatas);
        for (Sending current : imports) {
            sending.inject(current, spec);
        }
    }

    private InjectionSpec getInjectionSpec(final GoodsItems masterDatas) {
        return new InjectionSpec(false, true, true){

            @Override
            public boolean injectTarget(INode<?> target, INode<?> other) {
                if (this.isSendingId(target)) {
                    return false;
                }
                if (!other.isReadValue()) {
                    return false;
                }
                if (this.isReference(target)) {
                    this.handleReference(target, other);
                    return false;
                }
                if (this.isDefaultCurrency(target)) {
                    this.handleCurrency((StringNodeBase)target, (StringNodeBase)other);
                    return false;
                }
                return true;
            }

            private void handleCurrency(StringNodeBase<?> target, StringNodeBase<?> other) {
                if (!target.getStringValue().equals("CHF") && other.getStringValue().equals("CHF")) {
                    return;
                }
                target.applyStringNode(other);
            }

            private void handleReference(INode<?> target, INode<?> other) {
                StringNodeBase targetStr = (StringNodeBase)target;
                StringNodeBase otherStr = (StringNodeBase)other;
                StringBuilder str = new StringBuilder(targetStr.getValue());
                if (str.length() != 0) {
                    str.append(", ");
                }
                str.append(otherStr.getValue());
                targetStr.setValue(str.toString());
            }

            @Override
            public void repair(ModelNode<?> parent, INode<?> target, INode<?> other) {
                if (target instanceof SelectionNode) {
                    ImportModel.this.handleSelectionNode((SelectionNode)target, (SelectionNode)other);
                }
                if (target instanceof GoodsItem) {
                    ImportModel.this.handleGoodsItem(parent, (GoodsItem)target, (GoodsItem)other, masterDatas);
                }
            }

            private boolean isReference(INode<?> node) {
                return node.isFieldName("traderReference");
            }

            private boolean isSendingId(INode<?> node) {
                return node.isFieldName("sendingId");
            }

            private boolean isDefaultCurrency(INode<?> node) {
                return node.isFieldName("defaultCurrency");
            }
        };
    }

    private void handleGoodsItem(INode<?> parent, GoodsItem target, GoodsItem other, GoodsItems masterDatas) {
        this.repairCurrency(parent, target.getGoodsData());
        GoodsItem masterData = null;
        int importKey = Services.get(IConfigService.class).getOptionInfo().getImportInfo().getImportKey().asInt();
        switch (importKey) {
            case 0: {
                return;
            }
            case 1: {
                if (!target.getId().isInitialized()) {
                    return;
                }
                masterData = this.getMasterDataById(target.getId().getValue(), masterDatas.getGoodsItems());
                break;
            }
            case 2: {
                if (!target.getGoodsData().getCommodityCode().isInitialized()) {
                    return;
                }
                masterData = this.getMasterDataByCommodityCode(target.getGoodsData().getCommodityCode().getValue(), masterDatas.getGoodsItems());
            }
        }
        if (masterData == null) {
            return;
        }
        target.inject(masterData, new InjectionSpec(false, true, true));
    }

    private void repairCurrency(INode<?> itemList, GoodsData goodsData) {
        if (goodsData.getCurrency().isInitialized() && goodsData.getCurrencyRate().isInitialized()) {
            return;
        }
        Sending sending = (Sending)itemList.getParent().getParent();
        if (sending.getGoodsDeclaration().getDefaultCurrency().isInitialized()) {
            goodsData.getCurrency().apply(sending.getGoodsDeclaration().getDefaultCurrency());
        }
        if (!goodsData.getCurrency().isInitialized()) {
            goodsData.getCurrency().setValue("CHF");
        }
        this.repairCurrencyRate(goodsData);
    }

    private void repairCurrencyRate(GoodsData goodsData) {
        Services.get(IDataService.class).executeOnMasterdata(DataFiles.currency, masterData -> {
            Currency currency = masterData.findCurrency(goodsData.getCurrency().getStringValue());
            if (currency != null) {
                goodsData.getCurrencyRate().apply(currency.getRate());
                return;
            }
            if (!goodsData.getCurrencyRate().isInitialized()) {
                goodsData.getCurrencyRate().setValue(1);
            }
        });
    }

    private GoodsItem getMasterDataById(String id, ListNode<GoodsItem> listNode) {
        for (GoodsItem current : listNode) {
            if (!current.getId().isInitialized() || !current.getId().getValue().equals(id)) continue;
            return current;
        }
        return null;
    }

    private GoodsItem getMasterDataByCommodityCode(String commodityCode, ListNode<GoodsItem> listNode) {
        for (GoodsItem current : listNode) {
            if (!current.getGoodsData().getCommodityCode().isInitialized() || !current.getGoodsData().getCommodityCode().getValue().equals(commodityCode)) continue;
            return current;
        }
        return null;
    }

    private void handleSelectionNode(SelectionNode target, SelectionNode other) {
        if (!other.isInitialized()) {
            return;
        }
        if (other.getDomainData().getDomain() != Domain.isoCode) {
            return;
        }
        if (target.isValueInDomainData()) {
            return;
        }
        String key = other.getValue().getKey();
        for (DomainValue current : target.getDomainData()) {
            if (!current.containsText(key)) continue;
            target.setValue(current, true);
            return;
        }
    }

    public void deleteMerkedSendings() {
        this.importTableModel.deleteAllMarked();
    }

    public boolean selectFiles(String consigneeId) {
        if (consigneeId.isEmpty()) {
            return false;
        }
        ArrayList<SendingInfo> result = new ArrayList<SendingInfo>();
        for (SendingInfo info : this.importTableModel.getSendingInfos()) {
            if (!info.getSending().getGoodsDeclaration().getConsignee().getId().getValue().equals(consigneeId)) continue;
            result.add(info);
        }
        if (result.isEmpty()) {
            return false;
        }
        this.selectionModel.clearSelection();
        for (SendingInfo info : result) {
            int index = this.table.convertRowIndexToView(this.importTableModel.getIndex(info));
            this.selectionModel.addSelectionInterval(index, index);
        }
        return true;
    }
}

