/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.imp;

import ch.transsoft.edec.model.infra.LoggingContext;
import ch.transsoft.edec.model.sending.Sending;
import java.io.File;

public class SendingInfo {
    private File fileSystemLocation;
    private Sending sending;
    private final LoggingContext info;
    private final Exception exception;

    public SendingInfo(File fileSystemLocation, Sending sending, LoggingContext info) {
        this(fileSystemLocation, sending, info, null);
    }

    public SendingInfo(File fileSystemLocation, Sending sending, Exception exception) {
        this(fileSystemLocation, sending, new LoggingContext(), exception);
    }

    public SendingInfo(File fileSystemLocation, Sending sending, LoggingContext info, Exception exception) {
        this.fileSystemLocation = fileSystemLocation;
        this.sending = sending;
        this.info = info;
        this.exception = exception;
    }

    public Sending getSending() {
        return this.sending;
    }

    public File getFile() {
        return this.fileSystemLocation;
    }

    public File getFileSystemLocation() {
        return this.fileSystemLocation;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean hasError() {
        return this.exception != null;
    }

    public boolean hasInfo() {
        return this.info.hasMessage();
    }

    public String getInfos() {
        return this.info.getMessage();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileSystemLocation == null ? 0 : this.fileSystemLocation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SendingInfo other = (SendingInfo)obj;
        return !(this.fileSystemLocation == null ? other.fileSystemLocation != null : !this.fileSystemLocation.equals(other.fileSystemLocation));
    }
}

