/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.model;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.text.NumberFormat;

public class DecimalPm
extends SimpleDocument
implements IDisposable {
    private final DecimalNode node;
    private final Disposables disposables = new Disposables();
    private boolean enabled = true;
    private final ListenerList<IPmListener> listeners = new ListenerList();

    public DecimalPm(DecimalNode node) {
        this.node = node;
        if (node.isInitialized()) {
            this.setValue(node.getValue());
        }
        this.addListener();
    }

    public void addErrorListener(IErrorListener listener) {
        this.disposables.add(this.node.addErrorListener(listener));
    }

    private void setValue(Number value) {
        String str;
        String string = str = value == null ? "" : this.node.getFormat().format(value);
        if (str.equals(this.getText())) {
            return;
        }
        this.setText(str);
    }

    private void addListener() {
        this.disposables.add(this.node.addChangeListener(this.createNodeListener()));
    }

    private IChangeListener createNodeListener() {
        return (source, info) -> this.setValue(this.node.getValue());
    }

    public boolean isMandatory() {
        return this.node.isMandatory();
    }

    public void triggerDataChanged() {
        this.node.setValue(this.parseValue());
        this.setText(this.node.toString());
    }

    private Number parseValue() {
        try {
            NumberFormat format = this.node.getFormat();
            return format.parse(this.getText());
        }
        catch (Exception e2) {
            return null;
        }
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ErrorInfo getErrorInfo() {
        return this.node.getErrorInfo();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        for (IPmListener listener : this.listeners) {
            listener.enabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void add(IPmListener listener) {
        this.listeners.add(listener);
    }

    public void addChangeListener(IChangeListener changeListener) {
        this.disposables.add(this.node.addChangeListener(changeListener));
    }

    public Double getValue() {
        return this.node.getValue();
    }
}

