/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.model;

import ch.transsoft.edec.util.Check;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class MaxLineFilter
extends DocumentFilter {
    private final int max;
    private final JTextArea textArea;

    public MaxLineFilter(int max, JTextArea textArea) {
        Check.assertNotNull(textArea);
        this.max = max;
        this.textArea = textArea;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet attr) throws BadLocationException {
        if (this.textArea.getSize().getWidth() == 0.0) {
            super.insertString(fb, offset, str, attr);
            return;
        }
        this.replace(fb, offset, 0, str, attr);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String str, AttributeSet attr) throws BadLocationException {
        String oldStr = fb.getDocument().getText(0, fb.getDocument().getLength());
        int oldLineCount = this.getLineCount(fb.getDocument());
        int caret = this.textArea.getCaretPosition();
        fb.replace(offset, length, str, attr);
        int lineCount = this.getLineCount(fb.getDocument());
        if (lineCount > this.max && lineCount > oldLineCount) {
            Toolkit.getDefaultToolkit().beep();
            fb.remove(0, fb.getDocument().getLength());
            fb.insertString(0, oldStr, null);
            this.textArea.setCaretPosition(caret);
        }
    }

    private int getLineCount(Document doc) {
        return this.getEndOfLineIndices(doc).size() + 1;
    }

    private List<Integer> getEndOfLineIndices(Document doc) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int y = 0;
        for (int i2 = 0; i2 < doc.getLength() + 1; ++i2) {
            int currenty = this.modelToView(i2);
            if (currenty == y) continue;
            y = currenty;
            result.add(i2);
        }
        return result;
    }

    private int modelToView(int i2) {
        try {
            Rectangle2D modelToView = this.textArea.modelToView2D(i2);
            return (int)modelToView.getY();
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2);
        }
    }
}

