/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.model;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import ch.transsoft.edec.ui.pm.model.ISelectionPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.ListenerList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SelectionPm
implements ISelectionPm<DomainValue> {
    private final DefaultComboBoxModel<DomainValue> model = new DefaultComboBoxModel();
    private final SelectionNode node;
    private final Disposables disposables = new Disposables();
    private boolean enabled = true;
    private final ListenerList<IPmListener> listeners = new ListenerList();
    private boolean editable = true;
    private String tooltip;

    public SelectionPm(SelectionNode node) {
        this.node = node;
        if (node.getDomainData().allowEmpty()) {
            this.model.addElement(DomainValue.getUninitialized());
        }
        for (DomainValue current : node.getDomainData()) {
            this.model.addElement(current);
        }
        DomainValue current = node.getValue();
        this.model.setSelectedItem(current.isInitialized() ? current : null);
        this.addPmListener();
        this.addNodeListener();
    }

    @Override
    public void addErrorListener(IErrorListener listener) {
        this.disposables.add(this.node.addErrorListener(listener));
    }

    private void addNodeListener() {
        this.disposables.add(this.node.addChangeListener((source, info) -> this.handleNodeChanged(this.node)));
    }

    private void handleNodeChanged(SelectionNode node) {
        this.model.setSelectedItem(node.getValue());
    }

    private void addPmListener() {
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                SelectionPm.this.handlePmChange();
            }
        });
    }

    private void handlePmChange() {
        this.node.setCurrentValue((DomainValue)this.model.getSelectedItem(), false);
    }

    @Override
    public boolean isMandatory() {
        return this.node.isMandatory();
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.node.getErrorInfo();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        for (IPmListener listener : this.listeners) {
            listener.enabled(enabled);
        }
    }

    @Override
    public void add(IPmListener listener) {
        this.listeners.add(listener);
    }

    public void add(IChangeListener listener) {
        this.disposables.add(this.node.addChangeListener(listener));
    }

    public DomainValue getCurrentValue() {
        return this.node.getValue();
    }

    public boolean isInitialized() {
        return this.node.isInitialized();
    }

    public void setEditableTrue() {
        if (this.editable) {
            return;
        }
        this.editable = true;
        this.tooltip = null;
        this.triggerEditableChanged(null);
    }

    public void setEditableFalse(String reason) {
        if (!this.editable) {
            return;
        }
        this.editable = false;
        this.tooltip = reason;
        this.triggerEditableChanged(reason);
    }

    private void triggerEditableChanged(String reason) {
        for (IPmListener listener : this.listeners) {
            listener.editable(this.editable, reason);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.model.setSelectedItem(anItem);
    }

    @Override
    public int getSize() {
        return this.model.getSize();
    }

    @Override
    public DomainValue getElementAt(int index) {
        return this.model.getElementAt(index);
    }

    @Override
    public void addListDataListener(ListDataListener l2) {
        this.model.addListDataListener(l2);
    }

    @Override
    public void removeListDataListener(ListDataListener l2) {
        this.model.removeListDataListener(l2);
    }

    @Override
    public DomainValue getSelectedItem() {
        return (DomainValue)this.model.getSelectedItem();
    }

    public int getIndexOf(Object obj) {
        return this.model.getIndexOf(obj);
    }
}

