/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.event.CustomsItemListCreated;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.sending.ErrorPm;
import ch.transsoft.edec.ui.pm.sending.forms.FormsPm;
import ch.transsoft.edec.ui.pm.sending.heading.HeadingPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.ItemListPm;
import ch.transsoft.edec.ui.pm.sending.statusline.StatusLinePm;
import ch.transsoft.edec.util.ReflectionUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class SendingPm
implements IPm,
IDisposable {
    private final StatusLinePm statusLinePm;
    private final HeadingPm headPm;
    private final ItemListPm itemListPm;
    private ItemListPm customsItemListPm;
    private final FormsPm formsPm;
    private final ErrorPm errorPm;
    private final Disposables disposables = new Disposables();
    private final Sending sending;

    public SendingPm(Sending sending) {
        this.sending = sending;
        this.statusLinePm = new StatusLinePm(sending);
        this.formsPm = new FormsPm(sending);
        this.headPm = new HeadingPm(sending);
        this.itemListPm = new ItemListPm(sending.getItemList(), sending);
        this.customsItemListPm = new ItemListPm(sending.getCustomsItemList(), null);
        this.errorPm = new ErrorPm();
    }

    public StatusLinePm getStatusLinePm() {
        return this.statusLinePm;
    }

    public HeadingPm getHeadingPm() {
        return this.headPm;
    }

    public ItemListPm getItemListPm() {
        return this.itemListPm;
    }

    public void recreateCustomsItemListPm() {
        ReflectionUtil.recursiveDispose(this.customsItemListPm);
        this.customsItemListPm = new ItemListPm(this.sending.getCustomsItemList(), null);
    }

    public ItemListPm getCustomsItemListPm() {
        return this.customsItemListPm;
    }

    public FormsPm getFormsPm() {
        return this.formsPm;
    }

    public ErrorPm getErrorPm() {
        return this.errorPm;
    }

    public void add(IErrorListener listener) {
        this.disposables.add(this.sending.addErrorListener(listener));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public Disposables getDisposables() {
        return this.disposables;
    }

    public void addCustomsItemListListener(IChangeListener iChangeListener) {
        this.disposables.add(this.sending.addChangeListener((source, info) -> {
            if (source != this.sending) {
                return;
            }
            if (info instanceof CustomsItemListCreated) {
                iChangeListener.changed(source, info);
            }
        }));
    }

    public boolean sendingHasError() {
        return this.sending.getErrorInfo().hasError();
    }
}

