/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.forms;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormService;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.sending.forms.FormPm;
import ch.transsoft.edec.ui.pm.sending.forms.IFormSelectionListener;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class FormsPm
extends AbstractTableModel
implements IPm,
IDisposable,
ListSelectionListener {
    private static final String[] formNames = new String[]{Services.getText(1541), Services.getText(1542)};
    private final List<IFormDesc> formList;
    private final ListenerList<IFormSelectionListener> listeners = new ListenerList();
    private final Disposables disposables = new Disposables();
    private FormPm currentFormPm;
    private final Sending sending;

    public FormsPm(Sending sending) {
        this.sending = sending;
        this.formList = Services.get(IFormService.class).getForms();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.formList.size();
    }

    @Override
    public String getColumnName(int column) {
        return formNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return Boolean.class;
        }
        throw Check.fail("unknown collumn: ", columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.formList.get(rowIndex).getName();
        }
        if (columnIndex == 1) {
            return this.sending.getForms().isSelected(this.formList.get(rowIndex));
        }
        throw Check.fail("unknown collumn: ", columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Check.assertEquals(1, columnIndex);
        this.sending.getForms().setSelected(this.formList.get(rowIndex), (Boolean)aValue);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        selectionModel.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e2) {
        if (e2.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel model = (ListSelectionModel)e2.getSource();
        IFormDesc selected = this.formList.get(model.getLeadSelectionIndex());
        for (IFormSelectionListener listener : this.listeners) {
            listener.selected(selected);
        }
    }

    public IDisposable addSelectionListener(IFormSelectionListener listener) {
        return this.listeners.add(listener);
    }

    public void addSendingListener(IChangeListener listener) {
        this.disposables.add(this.sending.addChangeListener(listener));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public Sending getSending() {
        return this.sending;
    }

    public void add(IErrorListener listener) {
        this.disposables.add(this.sending.getForms().addErrorListener(listener));
    }

    public boolean hasError(int row) {
        IFormDesc form = this.formList.get(row);
        INode<?> node = this.getFormNode(form);
        return node.getErrorInfo().hasError();
    }

    private INode<?> getFormNode(IFormDesc form) {
        try {
            Field field = this.sending.getForms().getClass().getDeclaredField(form.getId().name());
            field.setAccessible(true);
            return (INode)field.get(this.sending.getForms());
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }

    public FormPm getCurrentFormPm() {
        return this.currentFormPm;
    }

    public void setCurrentFormPm(FormPm newFormPm) {
        if (this.currentFormPm != null) {
            this.currentFormPm.dispose();
        }
        this.currentFormPm = newFormPm;
    }
}

