/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.heading;

import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.model.sending.goodsdeclaration.GoodsDeclaration;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.gui.sending.heading.ConsigneePanel;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ConsigneePm
implements IPm,
IDisposable {
    private final StringPm name;
    private final StringPm street;
    private final StringPm addressSupplement1;
    private final StringPm addressSupplement2;
    private final StringPm postalCode;
    private final StringPm city;
    private final SelectionPm country;
    private final Address address;
    private final TitledBorder titleBorder = new TitledBorder("");
    private final Disposables disposables = new Disposables();
    private final GoodsDeclaration goodsDeclaration;
    private ConsigneePanel consigneePanel;

    public ConsigneePm(GoodsDeclaration goodsDeclaration) {
        this.goodsDeclaration = goodsDeclaration;
        this.address = goodsDeclaration.getConsignee();
        this.name = new StringPm(this.address.getName());
        this.street = new StringPm(this.address.getStreet());
        this.addressSupplement1 = new StringPm(this.address.getAddressSupplement1());
        this.addressSupplement2 = new StringPm(this.address.getAddressSupplement2());
        this.postalCode = new StringPm(this.address.getPostalCode());
        this.city = new StringPm(this.address.getCity());
        this.country = new SelectionPm(this.address.getCountry());
        this.disposables.add(goodsDeclaration.getDelivery().addChangeListener(this.createNodeListener()));
        this.updateConsigneeTitle();
    }

    private IChangeListener createNodeListener() {
        return (source, info) -> this.updateConsigneeTitle();
    }

    private void updateConsigneeTitle() {
        String text = this.goodsDeclaration.getDelivery().isEnabled() ? Services.getText(1161) : Services.getText(1110);
        this.titleBorder.setTitle(text);
        if (this.consigneePanel != null) {
            this.consigneePanel.repaint();
        }
    }

    public StringPm getName() {
        return this.name;
    }

    public StringPm getStreet() {
        return this.street;
    }

    public StringPm getAddressSupplement1() {
        return this.addressSupplement1;
    }

    public StringPm getAddressSupplement2() {
        return this.addressSupplement2;
    }

    public StringPm getPostalCode() {
        return this.postalCode;
    }

    public StringPm getCity() {
        return this.city;
    }

    public SelectionPm getCountry() {
        return this.country;
    }

    public void apply(Address t) {
        this.address.apply(t);
    }

    public Border getTitleBorder() {
        return this.titleBorder;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public void setPanel(ConsigneePanel consigneePanel) {
        this.consigneePanel = consigneePanel;
    }
}

