/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.heading;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.masterdata.Currency;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.Container;
import ch.transsoft.edec.model.sending.goodsdeclaration.GoodsDeclaration;
import ch.transsoft.edec.model.sending.goodsdeclaration.SpecialMentionHeader;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.ui.pm.model.EnabledPm;
import ch.transsoft.edec.ui.pm.model.IBooleanPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.ISelectionPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.ui.pm.sending.heading.BondedWarehousePm;
import ch.transsoft.edec.ui.pm.sending.heading.CarrierPm;
import ch.transsoft.edec.ui.pm.sending.heading.ConsigneePm;
import ch.transsoft.edec.ui.pm.sending.heading.ConsignorPm;
import ch.transsoft.edec.ui.pm.sending.heading.DeclarantPm;
import ch.transsoft.edec.ui.pm.sending.heading.DeliveryPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.CurrencyPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class HeadingPm
implements IPm,
IDisposable {
    private final ConsignorPm consignor;
    private final DeclarantPm declarant;
    private final ConsigneePm consignee;
    private final IBooleanPm deliveryAsConsignee;
    private final DeliveryPm delivery;
    private final CarrierPm carrier;
    private final StringPm traderDeclarationNumber;
    private final StringPm traderReference;
    private final SelectionPm deliveryDestination;
    private final SelectionPm declarationType;
    private final SelectionPm clearanceLocation;
    private final SelectionPm customsOfficeNumber;
    private final SelectionPm transferToTransitSystem;
    private final SelectionPm correctionCode;
    private final SelectionPm correctionReason;
    private final SelectionPm transportMode;
    private final SelectionPm transportationCountry;
    private final StringPm transportationNumber;
    private final SelectionPm incoterms;
    private final StringPm companyNumberTaxpayer;
    private final SelectionPm invoiceCurrency;
    private final TablePm<SpecialMentionHeader> specialMentions;
    private final CurrencyPm defaultCurrency;
    private final StringPm defaultPackagingReferenceNumber;
    private final IBooleanPm hasContainers;
    private final IBooleanPm hasBondedWarehouse;
    private final TablePm<Container> containers;
    private final StringPm internalComment;
    private final BondedWarehousePm bondedWarehousePm;
    private final Disposables disposables = new Disposables();
    private final Sending sending;

    public HeadingPm(Sending sending) {
        this.sending = sending;
        GoodsDeclaration goodsDeclaration = sending.getGoodsDeclaration();
        this.consignor = new ConsignorPm(goodsDeclaration.getConsignor());
        this.declarant = new DeclarantPm(goodsDeclaration.getDeclarant());
        this.consignee = new ConsigneePm(goodsDeclaration);
        this.delivery = new DeliveryPm(goodsDeclaration.getDelivery());
        this.deliveryAsConsignee = new EnabledPm(goodsDeclaration.getDelivery());
        this.carrier = new CarrierPm(goodsDeclaration.getCarrier());
        this.traderDeclarationNumber = new StringPm(goodsDeclaration.getTraderDeclarationNumber());
        this.traderReference = new StringPm(goodsDeclaration.getTraderReference());
        this.deliveryDestination = new SelectionPm(goodsDeclaration.getDeliveryDestination());
        this.declarationType = new SelectionPm(goodsDeclaration.getDeclarationType());
        this.clearanceLocation = new SelectionPm(goodsDeclaration.getClearanceLocation());
        this.transferToTransitSystem = new SelectionPm(goodsDeclaration.getTransferToTransitSystem());
        this.customsOfficeNumber = new SelectionPm(goodsDeclaration.getCustomsOfficeNumber());
        this.correctionCode = new SelectionPm(goodsDeclaration.getCorrectionCode());
        this.correctionReason = new SelectionPm(goodsDeclaration.getCorrectionReason());
        this.transportMode = new SelectionPm(goodsDeclaration.getTransportMeans().getTransportMode());
        this.transportationCountry = new SelectionPm(goodsDeclaration.getTransportMeans().getTransportationCountry());
        this.transportationNumber = new StringPm(goodsDeclaration.getTransportMeans().getTransportationNumber());
        this.incoterms = new SelectionPm(goodsDeclaration.getBusiness().getIncoterms());
        this.invoiceCurrency = new SelectionPm(goodsDeclaration.getBusiness().getInvoiceCurrency());
        this.companyNumberTaxpayer = new StringPm(goodsDeclaration.getBusiness().getCompanyNumberTaxpayer());
        this.defaultCurrency = new CurrencyPm(goodsDeclaration.getDefaultCurrency(), new DecimalNode(0.0, 1, 1));
        this.defaultPackagingReferenceNumber = new StringPm(goodsDeclaration.getDefaultPackagingReferenceNumber());
        this.specialMentions = new TablePm<SpecialMentionHeader>(goodsDeclaration.getSpecialMentions(), SpecialMentionHeader.class, SpecialMentionHeader.tableConfig);
        this.hasContainers = new EnabledPm(goodsDeclaration.getContainers());
        this.hasBondedWarehouse = new EnabledPm(goodsDeclaration.getBondedWarehouse());
        this.containers = new TablePm<Container>(goodsDeclaration.getContainers(), Container.class, Container.tableConfig);
        this.bondedWarehousePm = new BondedWarehousePm(goodsDeclaration.getBondedWarehouse());
        this.internalComment = new StringPm(goodsDeclaration.getInternalComment());
        this.addStateListener();
    }

    private void addStateListener() {
        this.disposables.add(this.sending.getState().addChangeListener((source, info) -> this.updateState()));
    }

    public void updateState() {
        if (this.sending.getState().hasAl()) {
            this.traderDeclarationNumber.setEditableFalse(Services.getText(1543));
        } else {
            this.traderDeclarationNumber.setEditableTrue();
        }
    }

    public ConsigneePm getConsignee() {
        return this.consignee;
    }

    public DeliveryPm getDelivery() {
        return this.delivery;
    }

    public CarrierPm getCarrier() {
        return this.carrier;
    }

    public IBooleanPm getDeliveryAsConsignee() {
        return this.deliveryAsConsignee;
    }

    public IBooleanPm getHasContainers() {
        return this.hasContainers;
    }

    public IBooleanPm getHasBondedWarehouse() {
        return this.hasBondedWarehouse;
    }

    public StringPm getTraderReference() {
        return this.traderReference;
    }

    public SelectionPm getDeliveryDestination() {
        return this.deliveryDestination;
    }

    public SelectionPm getDeclarationType() {
        return this.declarationType;
    }

    public SelectionPm getClearanceLocation() {
        return this.clearanceLocation;
    }

    public SelectionPm getCorrectionCode() {
        return this.correctionCode;
    }

    public SelectionPm getCorrectionReason() {
        return this.correctionReason;
    }

    public SelectionPm getTransportMode() {
        return this.transportMode;
    }

    public SelectionPm getTransportationCountry() {
        return this.transportationCountry;
    }

    public StringPm getTransportationNumber() {
        return this.transportationNumber;
    }

    public SelectionPm getIncoterms() {
        return this.incoterms;
    }

    public StringPm getCompanyNumberTaxpayer() {
        return this.companyNumberTaxpayer;
    }

    public TablePm<SpecialMentionHeader> getSpecialMentions() {
        return this.specialMentions;
    }

    public TablePm<Container> getContainers() {
        return this.containers;
    }

    public BondedWarehousePm getBondedWarehousePm() {
        return this.bondedWarehousePm;
    }

    public StringPm getInternalComment() {
        return this.internalComment;
    }

    public DeclarantPm getDeclarant() {
        return this.declarant;
    }

    public ConsignorPm getConsignor() {
        return this.consignor;
    }

    public StringPm getTraderDeclarationNumber() {
        return this.traderDeclarationNumber;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public void add(IErrorListener listener) {
        this.disposables.add(this.sending.getGoodsDeclaration().addErrorListener(listener));
    }

    public ISelectionPm<Currency> getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public ISelectionPm<DomainValue> getInvoiceCurrency() {
        return this.invoiceCurrency;
    }

    public StringPm getDefaultPackagingReferenceNumber() {
        return this.defaultPackagingReferenceNumber;
    }

    public void addEnableDeliveryListener(IChangeListener listener) {
        this.disposables.add(this.sending.addFieldListener("delivery", listener));
    }

    public ISelectionPm<DomainValue> getTransferToTransitSystem() {
        return this.transferToTransitSystem;
    }

    public ISelectionPm<DomainValue> getCustomsOfficeNumber() {
        return this.customsOfficeNumber;
    }
}

