/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Confirmation;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.BooleanPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class ConfirmationPm
implements IPm,
IDisposable {
    private final Confirmation data;
    private final Disposables disposables = new Disposables();
    private final BooleanPm statisticalValueConfirmationPm;
    private final BooleanPm grossMassConfirmationPm;
    private final BooleanPm netMassConfirmationPm;
    private final BooleanPm additionalUnitConfirmationPm;

    public ConfirmationPm(Confirmation data) {
        this.data = data;
        this.statisticalValueConfirmationPm = new BooleanPm(data.getStatisticalValueConfirmation());
        this.grossMassConfirmationPm = new BooleanPm(data.getGrossMassConfirmation());
        this.netMassConfirmationPm = new BooleanPm(data.getNetMassConfirmation());
        this.additionalUnitConfirmationPm = new BooleanPm(data.getAdditionalUnitConfirmation());
    }

    public void add(IErrorListener errorListener) {
        this.disposables.add(this.data.addErrorListener(errorListener));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ErrorInfo getErrorInfo() {
        return this.data.getErrorInfo();
    }

    public Disposables getDisposables() {
        return this.disposables;
    }

    public BooleanPm getStatisticalValueConfirmationPm() {
        return this.statisticalValueConfirmationPm;
    }

    public BooleanPm getGrossMassConfirmationPm() {
        return this.grossMassConfirmationPm;
    }

    public BooleanPm getNetMassConfirmationPm() {
        return this.netMassConfirmationPm;
    }

    public BooleanPm getAdditionalUnitConfirmationPm() {
        return this.additionalUnitConfirmationPm;
    }
}

