/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.masterdata.Currencies;
import ch.transsoft.edec.model.masterdata.Currency;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import ch.transsoft.edec.ui.pm.model.ISelectionPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.ListenerList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class CurrencyPm
implements ISelectionPm<Currency> {
    private final DefaultComboBoxModel<Currency> model = new DefaultComboBoxModel();
    private final Disposables disposables = new Disposables();
    private boolean enabled = true;
    private final ListenerList<IPmListener> listeners;
    private final StringNode node;
    private final Currency currency;
    private boolean buildingModel = false;
    private Currencies currencies;
    private final DecimalNode rate;

    public CurrencyPm(StringNode currencyNode, DecimalNode rate) {
        this.node = currencyNode;
        this.rate = rate;
        this.currency = NodeFactory.create(Currency.class);
        this.currency.getName().setValue("CHF");
        this.currency.getRate().setValue(1);
        this.addMasterDataListener();
        this.buildModel(Services.get(IDataService.class).getMasterData(DataFiles.currency));
        this.addPmListener();
        this.addNodeListener();
        this.listeners = new ListenerList();
    }

    private void buildModel(Currencies masterData) {
        this.currencies = (Currencies)masterData.getCopy((ModelNode)null);
        this.currencies.getCurrencyList().add(0, this.currency);
        this.buildingModel = true;
        this.model.removeAllElements();
        this.model.addElement(NodeFactory.create(Currency.class));
        for (Currency current : this.currencies.getCurrencyList()) {
            this.model.addElement(current);
        }
        this.setSelection();
        this.buildingModel = false;
    }

    private void addMasterDataListener() {
        this.disposables.add(Services.get(IDataService.class).addDataListener(DataFiles.currency, this::buildModel));
    }

    private void setSelection() {
        Currency selection = this.currencies.findCurrency(this.node.getValue());
        if (selection == null) {
            selection = NodeFactory.create(Currency.class);
            selection.getName().setValue(this.node.getValue());
        }
        this.setSelectedItem(selection);
    }

    @Override
    public void addErrorListener(IErrorListener listener) {
        this.disposables.add(this.node.addErrorListener(listener));
    }

    private void addNodeListener() {
        this.disposables.add(this.node.addChangeListener((source, info) -> this.setSelection()));
    }

    private void addPmListener() {
        this.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                if (CurrencyPm.this.buildingModel) {
                    return;
                }
                CurrencyPm.this.handlePmChange();
            }
        });
    }

    private void handlePmChange() {
        Currency selected = this.getSelectedItem();
        this.node.apply(selected.getName());
        this.rate.apply(selected.getRate());
    }

    @Override
    public boolean isMandatory() {
        return this.node.isMandatory();
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.node.getErrorInfo();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        for (IPmListener listener : this.listeners) {
            listener.enabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void add(IPmListener listener) {
        this.listeners.add(listener);
    }

    public void addChangeListener(IChangeListener changeListener) {
        this.disposables.add(this.node.addChangeListener(changeListener));
    }

    public String getValue() {
        return this.node.getValue();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.model.setSelectedItem(anItem);
    }

    @Override
    public int getSize() {
        return this.model.getSize();
    }

    @Override
    public Currency getElementAt(int index) {
        return this.model.getElementAt(index);
    }

    @Override
    public void addListDataListener(ListDataListener l2) {
        this.model.addListDataListener(l2);
    }

    @Override
    public void removeListDataListener(ListDataListener l2) {
        this.model.removeListDataListener(l2);
    }

    @Override
    public Currency getSelectedItem() {
        return (Currency)this.model.getSelectedItem();
    }
}

