/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.INumberNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.BooleanPm;
import ch.transsoft.edec.ui.pm.model.DecimalPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.IntegralPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.CurrencyPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class GoodsDataPm
implements IPm,
IDisposable {
    private final GoodsData data;
    private final Disposables disposables = new Disposables();
    private final StringPm id;
    private final StringPm descriptionShort;
    private final StringPm descriptionEn;
    private final IntegralPm statisticalCode;
    private final StringPm commodityCode;
    private final SelectionPm origin;
    private final IntegralPm quantity;
    private final SelectionPm grossupType;
    private final SelectionPm packagingType;
    private final StringPm packageReferenceNumber;
    private final DecimalPm grossMass;
    private final DecimalPm netMass;
    private final SelectionPm customsClearanceType;
    private final SelectionPm commercialGood;
    private final DecimalPm statisticalValue;
    private final DecimalPm statisticalValueChf;
    private final CurrencyPm currency;
    private final DecimalPm currencyRate;
    private final DecimalPm additionalUnit;
    private final BooleanPm inEur;
    private final StringPm eurInvoices;
    private final StringPm bgLetter;
    private final SelectionPm refundType;
    private final DecimalPm VOCQuantity;
    private final GoodsItem goodsItem;

    public GoodsDataPm(GoodsItem goodsItem, boolean enableLogic) {
        this.goodsItem = goodsItem;
        this.data = goodsItem.getGoodsData();
        this.id = new StringPm(goodsItem.getId());
        this.commodityCode = new StringPm(this.data.getCommodityCode());
        this.origin = new SelectionPm(this.data.getOrigin());
        this.descriptionShort = new StringPm(this.data.getDescriptionShort());
        this.descriptionEn = new StringPm(this.data.getDescriptionEn());
        this.statisticalCode = new IntegralPm(this.data.getStatisticalCode());
        this.statisticalValue = new DecimalPm(this.data.getStatisticalValue());
        this.statisticalValueChf = new DecimalPm(this.data.getStatisticalValueChf());
        this.currency = new CurrencyPm(this.data.getCurrency(), this.data.getCurrencyRate());
        this.currencyRate = new DecimalPm(this.data.getCurrencyRate());
        this.setCurrencyRateEnabling();
        this.customsClearanceType = new SelectionPm(this.data.getCustomsClearanceType());
        this.commercialGood = new SelectionPm(this.data.getCommercialGood());
        this.quantity = new IntegralPm(this.data.getQuantity());
        this.grossupType = new SelectionPm(this.data.getGrossupType());
        this.packagingType = new SelectionPm(this.data.getPackagingType());
        this.packageReferenceNumber = new StringPm(this.data.getPackagingReferenceNumber());
        this.grossMass = new DecimalPm(this.data.getGrossMass());
        this.netMass = new DecimalPm(this.data.getNetMass());
        this.additionalUnit = new DecimalPm(this.data.getAdditionalUnit());
        this.eurInvoices = new StringPm(this.data.getEurInvoices());
        this.bgLetter = new StringPm(this.data.getBgLetter());
        this.inEur = new BooleanPm(this.data.getInEur());
        this.refundType = new SelectionPm(this.data.getRefundType());
        this.VOCQuantity = new DecimalPm(this.data.getVOCQuantity());
        if (enableLogic) {
            this.addQuantityListener();
            this.addAdditionalUnitListener();
            this.addGrossMassListener();
            this.addNetMassListener();
            this.addGrossupListener();
            this.addPackagingTypeListener();
            this.addCurrencyListener();
            this.addCurrencyRateListener();
        }
    }

    private void addPackagingTypeListener() {
        this.disposables.add(this.data.getPackagingType().addChangeListener((source, info) -> {
            if (this.data.getPackagingType().getValue().getKey().equals("--")) {
                this.data.getQuantity().clear();
            }
        }));
    }

    private void addAdditionalUnitListener() {
        this.disposables.add(this.data.getAdditionalUnit().addChangeListener((source, info) -> this.additionalUnitChanged((INumberNode)source)));
    }

    private void addGrossMassListener() {
        this.disposables.add(this.data.getGrossMass().addChangeListener((source, info) -> this.grossMassChanged((INumberNode)source)));
    }

    private void addNetMassListener() {
        this.disposables.add(this.data.getNetMass().addChangeListener((source, info) -> this.netMassChanged((INumberNode)source)));
    }

    private void addGrossupListener() {
        this.disposables.add(this.data.getGrossupType().addChangeListener((source, info) -> this.grossupChanged((SelectionNode)source)));
    }

    private void addQuantityListener() {
        this.disposables.add(this.data.getQuantity().addChangeListener((source, info) -> this.quantityChanged((INumberNode)source)));
    }

    private void grossupChanged(SelectionNode source) {
        if (source.asInt() == 0) {
            return;
        }
        if (source.asInt() == 1) {
            this.grossup(this.data.getQuantity());
        } else if (source.asInt() == 2) {
            this.grossup(this.data.getAdditionalUnit());
        } else if (source.asInt() == 3) {
            this.grossup(this.data.getGrossMass());
        } else if (source.asInt() == 4) {
            this.grossup(this.data.getNetMass());
        } else {
            Check.fail("unexpected grossupType: " + source.asInt());
        }
    }

    private void additionalUnitChanged(INumberNode<?> node) {
        if (this.data.getGrossupType().asInt() == 2) {
            this.grossup(node);
        }
    }

    private void grossMassChanged(INumberNode<?> node) {
        if (this.data.getGrossupType().asInt() == 3) {
            this.grossup(node);
        }
    }

    private void netMassChanged(INumberNode<?> node) {
        if (this.data.getGrossupType().asInt() == 4) {
            this.grossup(node);
        }
    }

    private void quantityChanged(INumberNode<?> node) {
        if (this.data.getGrossupType().asInt() == 1) {
            this.grossup(node);
        }
    }

    private void grossup(INumberNode<?> source) {
        if (!source.isInitialized()) {
            return;
        }
        if (!this.goodsItem.getId().isInitialized()) {
            return;
        }
        this.getMasterDataService().executeOnMasterdata(DataFiles.goodsItem, masterData -> this.quantityChanged(source, masterData.getGoodsItems()));
    }

    private void quantityChanged(INumberNode<?> source, ListNode<GoodsItem> listNode) {
        GoodsItem masterData = this.getMasterData(this.goodsItem.getId().getValue(), listNode);
        if (masterData == null) {
            return;
        }
        DecimalNode masterDataNode = masterData.getGoodsData().getStatisticalValue();
        this.computeValue(masterDataNode, source, this.data.getStatisticalValue());
        masterDataNode = masterData.getGoodsData().getNetMass();
        this.computeValue(masterDataNode, source, this.data.getNetMass());
        masterDataNode = masterData.getGoodsData().getVOCQuantity();
        this.computeValue(masterDataNode, source, this.data.getVOCQuantity());
        masterDataNode = masterData.getGoodsData().getNetMass();
        this.computeValue(masterDataNode, source, this.data.getNetMass());
        masterDataNode = masterData.getGoodsData().getGrossMass();
        this.computeValue(masterDataNode, source, this.data.getGrossMass());
        masterDataNode = masterData.getGoodsData().getAdditionalUnit();
        this.computeValue(masterDataNode, source, this.data.getAdditionalUnit());
    }

    private void computeValue(DecimalNode masterDataNode, INumberNode<?> source, DecimalNode currentNode) {
        if (source == currentNode) {
            return;
        }
        if (masterDataNode != null && masterDataNode.isInitialized()) {
            currentNode.setValue(source.getAsNumber().doubleValue() * masterDataNode.getValue());
        }
    }

    private GoodsItem getMasterData(String value, ListNode<GoodsItem> listNode) {
        for (GoodsItem current : listNode) {
            if (!current.getId().isInitialized() || !current.getId().getValue().equals(value)) continue;
            return current;
        }
        return null;
    }

    private IDataService getMasterDataService() {
        return Services.get(IDataService.class);
    }

    private void addCurrencyListener() {
        this.currency.addChangeListener((source, info) -> this.setCurrencyRateEnabling());
    }

    private void setCurrencyRateEnabling() {
        this.currencyRate.setEnabled(!this.currency.getValue().equals("CHF"));
    }

    private void addCurrencyRateListener() {
        this.currencyRate.addChangeListener((source, info) -> this.currencyRateChanged());
    }

    private void currencyRateChanged() {
        String thisCurrency = this.getCurrency().getValue();
        Double thisCurrencyRate = this.getCurrencyRate().getValue();
        if (thisCurrency == null || thisCurrencyRate == null) {
            return;
        }
        Sending sending = Services.get(IAppService.class).getCurrentSending();
        sending.setCurrencyRate(thisCurrency, thisCurrencyRate);
    }

    public void add(IErrorListener errorListener) {
        this.disposables.add(this.data.addErrorListener(errorListener));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ErrorInfo getErrorInfo() {
        return this.data.getErrorInfo();
    }

    public StringPm getDescriptionShort() {
        return this.descriptionShort;
    }

    public StringPm getDescriptionEn() {
        return this.descriptionEn;
    }

    public SelectionPm getCustomsClearanceType() {
        return this.customsClearanceType;
    }

    public SelectionPm getCommercialGood() {
        return this.commercialGood;
    }

    public DecimalPm getStatisticalValue() {
        return this.statisticalValue;
    }

    public IntegralPm getStatisticalCode() {
        return this.statisticalCode;
    }

    public StringPm getCommodityCode() {
        return this.commodityCode;
    }

    public SelectionPm getOrigin() {
        return this.origin;
    }

    public IntegralPm getQuantity() {
        return this.quantity;
    }

    public SelectionPm getGrossupType() {
        return this.grossupType;
    }

    public SelectionPm getPackagingType() {
        return this.packagingType;
    }

    public StringPm getPackageReferenceNumber() {
        return this.packageReferenceNumber;
    }

    public DecimalPm getStatisticalValueChf() {
        return this.statisticalValueChf;
    }

    public CurrencyPm getCurrency() {
        return this.currency;
    }

    public DecimalPm getCurrencyRate() {
        return this.currencyRate;
    }

    public DecimalPm getGrossMass() {
        return this.grossMass;
    }

    public DecimalPm getNetMass() {
        return this.netMass;
    }

    public BooleanPm getInEur() {
        return this.inEur;
    }

    public StringPm getEurInvoices() {
        return this.eurInvoices;
    }

    public StringPm getBgLetter() {
        return this.bgLetter;
    }

    public SelectionPm getRefundType() {
        return this.refundType;
    }

    public DecimalPm getVOCQuantity() {
        return this.VOCQuantity;
    }

    public DecimalPm getAdditionalUnit() {
        return this.additionalUnit;
    }

    public StringPm getId() {
        return this.id;
    }
}

