/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.DetailContainerPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.ItemTablePm;
import ch.transsoft.edec.ui.pm.sending.itemlist.TotalPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class ItemListPm
implements IPm,
IDisposable {
    private final ItemTablePm listPm;
    private final TotalPm totalPm;
    private final DetailContainerPm detailPm;
    private final ItemList itemList;
    private final Disposables disposables = new Disposables();

    public ItemListPm(ItemList itemList, Sending sending) {
        this.itemList = itemList;
        this.listPm = new ItemTablePm(itemList.getGoodsItems());
        this.totalPm = new TotalPm(itemList, sending);
        this.detailPm = new DetailContainerPm();
        this.listPm.addSelectionListener(this.detailPm);
        this.listPm.addSelectionListener(this.totalPm);
    }

    public ItemTablePm getListPm() {
        return this.listPm;
    }

    public TotalPm getTotalPm() {
        return this.totalPm;
    }

    public DetailContainerPm getDetailPm() {
        return this.detailPm;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public void add(IErrorListener listener) {
        this.disposables.add(this.itemList.addErrorListener(listener));
    }

    public boolean isEmpty() {
        return this.itemList.isEmpty();
    }
}

