/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.InjectionSpec;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.masterdata.GoodsItems;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.ui.dialog.insert.IInsertDialogTrait;
import ch.transsoft.edec.ui.dialog.insert.InsertDialog;
import ch.transsoft.edec.ui.pm.model.TablePm;

public final class ItemTablePm
extends TablePm<GoodsItem> {
    public ItemTablePm(ListNode<GoodsItem> node) {
        super(node, GoodsItem.class, GoodsItem.tableConfig);
    }

    @Override
    protected boolean configureEmptyLine(GoodsItem newRow, boolean addButton) {
        if (addButton) {
            this.showDialog(newRow);
        }
        this.setPackagingReferenceNumber(newRow);
        this.setCurrency(newRow);
        return true;
    }

    private void setCurrency(GoodsItem newRow) {
        if (newRow.getGoodsData().getCurrency().isInitialized()) {
            return;
        }
        Sending sending = Services.get(IAppService.class).getCurrentSending();
        newRow.getGoodsData().getCurrency().setValue(sending.getGoodsDeclaration().getDefaultCurrency().getValue());
    }

    private void setPackagingReferenceNumber(GoodsItem newRow) {
        if (newRow.getGoodsData().getPackagingReferenceNumber().isInitialized()) {
            return;
        }
        Sending sending = Services.get(IAppService.class).getCurrentSending();
        if (!newRow.getGoodsData().getPackagingType().getValue().getKey().equals("--")) {
            newRow.getGoodsData().getPackagingReferenceNumber().setValue(sending.getGoodsDeclaration().getDefaultPackagingReferenceNumber().getValue());
        }
    }

    private boolean showDialog(GoodsItem newRow) {
        IInsertDialogTrait trait = GoodsItems::getGoodsItems;
        InsertDialog<GoodsItem, GoodsItems> dialog = new InsertDialog<GoodsItem, GoodsItems>(Services.getText(1553), null, trait, DataFiles.goodsItem, GoodsItem.masterDatatableConfig, t -> {
            newRow.inject(t, new InjectionSpec(false, true, true));
            newRow.getGoodsData().getQuantity().fireEvent();
        });
        dialog.setVisible(true);
        dialog.dispose();
        return dialog.userSelectedRow();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return false;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }
}

