/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Notification;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class NotificationPm
implements IPm,
IDisposable {
    private final TablePm<Notification> notifications;
    private final ListNode<Notification> data;
    private final Disposables disposables = new Disposables();

    public NotificationPm(ListNode<Notification> data) {
        this.data = data;
        this.notifications = new TablePm<Notification>(data, Notification.class, Notification.tableConfig);
    }

    public TablePm<Notification> getNotifications() {
        return this.notifications;
    }

    public void add(IErrorListener errorListener) {
        this.disposables.add(this.data.addErrorListener(errorListener));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ErrorInfo getErrorInfo() {
        return this.data.getErrorInfo();
    }
}

