/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.RepairAndRefinement;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class RepairAndRefinementPm
implements IPm,
IDisposable {
    private SelectionPm direction;
    private SelectionPm refinementType;
    private SelectionPm processType;
    private SelectionPm billingType;
    private SelectionPm repair;
    private StringPm repairReason;
    private final RepairAndRefinement data;
    private final Disposables disposables = new Disposables();

    public RepairAndRefinementPm(RepairAndRefinement data) {
        this.data = data;
        this.direction = new SelectionPm(data.getDirection());
        this.refinementType = new SelectionPm(data.getRefinementType());
        this.processType = new SelectionPm(data.getProcessType());
        this.billingType = new SelectionPm(data.getBillingType());
        this.repair = new SelectionPm(data.getRepair());
        this.repairReason = new StringPm(data.getRepairReason());
    }

    public SelectionPm getDirection() {
        return this.direction;
    }

    public SelectionPm getRefinementType() {
        return this.refinementType;
    }

    public SelectionPm getProcessType() {
        return this.processType;
    }

    public SelectionPm getBillingType() {
        return this.billingType;
    }

    public RepairAndRefinement getData() {
        return this.data;
    }

    public Disposables getDisposables() {
        return this.disposables;
    }

    public SelectionPm getRepair() {
        return this.repair;
    }

    public StringPm getRepairReason() {
        return this.repairReason;
    }

    public void add(IErrorListener errorListener) {
        this.disposables.add(this.data.addErrorListener(errorListener));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ErrorInfo getErrorInfo() {
        return this.data.getErrorInfo();
    }
}

