/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist.action;

import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.SaveGoodsItemJob;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.ui.pm.sending.itemlist.action.IGoodsItemAction;
import java.awt.event.ActionEvent;

public class SaveInMasterdataAction
extends ActionBase
implements IGoodsItemAction {
    private GoodsItem item;

    public SaveInMasterdataAction() {
        super(Services.getText(201), "icon/Save-small.png");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.item == null) {
            return;
        }
        Services.get(IBackendService.class).put(new SaveGoodsItemJob(this, this.item));
    }

    @Override
    public void selectionChanged(GoodsItem current, boolean isEmptyLine) {
        if (isEmptyLine) {
            this.item = null;
            this.setEnabled(false);
            this.setTooltip(Services.getText(1550));
            return;
        }
        this.item = current;
        this.updateSaveButtonState();
    }

    public void updateSaveButtonState() {
        Services.get(IDataService.class).executeOnMasterdata(DataFiles.goodsItem, masterData -> this.updateSaveButtonState(masterData.getGoodsItems()));
    }

    private void updateSaveButtonState(ListNode<GoodsItem> masterData) {
        if (this.item == null) {
            return;
        }
        if (this.item.getId().isInitialized() && this.containsId(masterData, this.item.getId().getValue())) {
            this.setTooltip(Services.getText(1552));
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.setTooltip(Services.getText(1551));
        }
    }

    private boolean containsId(ListNode<GoodsItem> masterData, String id) {
        for (GoodsItem current : masterData) {
            if (!current.getId().isInitialized() || !current.getId().getValue().equals(id)) continue;
            return true;
        }
        return false;
    }
}

