/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.statusline;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.masterdataezv.IDomainData;
import ch.transsoft.edec.service.masterdataezv.IMasterDataEZVService;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.sending.forms.UnitConverterFactory;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.ui.pm.sending.statusline.SendingStatePm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.awt.Color;
import javax.swing.JTextArea;

public class StatusLinePm
implements IPm,
IDisposable {
    private final SendingStatePm sendingState;
    private final StringPm customsDeclarationNumberWithVersion;
    private final JTextArea customsState = new JTextArea();
    private final Disposables disposables = new Disposables();

    public StatusLinePm(Sending sending) {
        this.sendingState = new SendingStatePm(sending);
        this.customsDeclarationNumberWithVersion = new StringPm(sending.getGoodsDeclaration().getCustomsDeclarationNumberWithVersion());
        this.customsState.setOpaque(false);
        IUnitConverter uc = UnitConverterFactory.createPrintConverter();
        this.customsState.setFont(uc.getFont(Fonts.font12));
        this.customsState.setLineWrap(true);
        this.customsState.setWrapStyleWord(true);
        this.customsState.setEditable(false);
        this.customsState.setToolTipText(Services.getText(1555));
        this.showState(sending);
        this.addCustomsStatusListener(sending);
    }

    private void addCustomsStatusListener(Sending sending) {
        this.disposables.add(sending.addFieldListener("status", (source, info) -> this.showState(sending)));
    }

    protected void showState(Sending sending) {
        if (sending.getState().getStatus() == 0) {
            this.customsState.setText("");
            this.customsState.setToolTipText(Services.getText(1555));
            return;
        }
        String state = Integer.toString(sending.getState().getStatus());
        IDomainData status = Services.get(IMasterDataEZVService.class).getDomainData(Domain.status, false);
        if (!status.containsValue(state)) {
            this.customsState.setText(Services.getText(1554) + " " + state);
            return;
        }
        Color color = Design.getStatusColor(sending.getState().getStatus());
        this.customsState.setForeground(color);
        String desc = status.get(state).getDesc();
        this.customsState.setText(desc);
        this.customsState.setToolTipText(desc);
    }

    public JTextArea getCustomsState() {
        return this.customsState;
    }

    public SendingStatePm getSendingStatePm() {
        return this.sendingState;
    }

    public StringPm getCustomsDeclarationNumberWithVersion() {
        return this.customsDeclarationNumberWithVersion;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

