/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sendinglist;

import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.index.IArchiveChangeListener;
import ch.transsoft.edec.service.index.sending.IIndexService;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.sendinglist.IArchiveSearchPm;
import ch.transsoft.edec.ui.pm.sendinglist.IndexTablePmBase;
import ch.transsoft.edec.ui.pm.sendinglist.YearItem;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ArchiveTablePm
extends IndexTablePmBase
implements IPm,
IArchiveSearchPm,
IDisposable {
    private final Map<Integer, Index> archive = new LinkedHashMap<Integer, Index>();
    private int size = 0;
    private final DefaultComboBoxModel<YearItem> selectedPeriod = new DefaultComboBoxModel();
    private final Disposables disposables = new Disposables();

    public ArchiveTablePm(SimpleDocument searchModel) {
        super(searchModel);
        this.addComboListener();
        this.addListener();
    }

    private void addComboListener() {
        this.selectedPeriod.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                ArchiveTablePm.this.clearArchive();
                YearItem selection = ArchiveTablePm.this.getSelectedYearItem();
                HashSet<Integer> years = new HashSet<Integer>();
                years.add(selection.getYear());
                years.add(selection.getYear() - 1);
                Services.get(IIndexService.class).readArchive(years);
            }
        });
    }

    private YearItem getSelectedYearItem() {
        return (YearItem)this.selectedPeriod.getSelectedItem();
    }

    private void pupulateCombo() {
        for (int i2 = DateUtil.getCurrentYear(); i2 > 2000; --i2) {
            this.selectedPeriod.addElement(new YearItem(i2));
        }
    }

    public void initialize() {
        this.pupulateCombo();
    }

    private void addListener() {
        this.disposables.add(Services.get(IIndexService.class).add(new IArchiveChangeListener<IndexEntry, Index>(){

            @Override
            public void changed(int year, Index archivePart) {
                YearItem selected = ArchiveTablePm.this.getSelectedYearItem();
                if (selected.getYear() != year && selected.getYear() - 1 != year) {
                    return;
                }
                ArchiveTablePm.this.archive.put(year, archivePart);
                ArchiveTablePm.this.updatesize();
                ArchiveTablePm.this.fireTableDataChanged();
            }

            @Override
            public void clear() {
                ArchiveTablePm.this.clearArchive();
            }
        }));
    }

    private void clearArchive() {
        this.archive.clear();
        this.updatesize();
        this.fireTableDataChanged();
    }

    private void updatesize() {
        int result = 0;
        for (Index current : this.archive.values()) {
            result += current.getEntryList().size();
        }
        this.size = result;
    }

    @Override
    public int getRowCount() {
        return this.size;
    }

    @Override
    public IndexEntry getIndexEntry(int row) {
        int offset = 0;
        Iterator<Index> iterator = this.archive.values().iterator();
        while (iterator.hasNext()) {
            int index = row - offset;
            Index current = iterator.next();
            if (index < current.getEntryList().size()) {
                return current.getEntryList().get(index);
            }
            offset += current.getEntryList().size();
        }
        throw Check.fail("index not found: ", row);
    }

    public DefaultComboBoxModel<YearItem> getSelectedPeriod() {
        return this.selectedPeriod;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

