/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sendinglist;

import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.index.IIndexChangeListener;
import ch.transsoft.edec.service.index.sending.IIndexService;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexSearchPm;
import ch.transsoft.edec.ui.pm.sendinglist.IndexTablePmBase;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class IndexTablePm
extends IndexTablePmBase
implements IPm,
IIndexSearchPm,
IDisposable {
    private Index index;
    private Disposables disposables = new Disposables();

    public IndexTablePm(SimpleDocument searchModel) {
        super(searchModel);
        this.index = NodeFactory.create(Index.class);
        this.addListener();
    }

    public void initialize() {
        Services.get(IIndexService.class).readIndex();
    }

    private void addListener() {
        this.disposables.add(Services.get(IIndexService.class).add(new IIndexChangeListener<IndexEntry, Index>(){

            @Override
            public void changed(Index newIndex) {
                Check.assertNotNull(newIndex);
                IndexTablePm.this.index = newIndex;
                IndexTablePm.this.fireTableDataChanged();
            }

            @Override
            public void clear() {
                IndexTablePm.this.index = NodeFactory.create(Index.class);
                IndexTablePm.this.fireTableDataChanged();
            }
        }));
    }

    @Override
    public int getRowCount() {
        return this.index.getEntryList().size();
    }

    @Override
    public IndexEntry getIndexEntry(int row) {
        return this.index.getEntryList().get(row);
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

