/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sendinglist;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexTablePmListener;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.ListenerList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;

public abstract class IndexTablePmBase
extends AbstractTableModel {
    public static final String SERACH = Services.getText(1556);
    private final ITableAdapter[] configs;
    private final SimpleDocument searchModel;
    private final ListenerList<IIndexTablePmListener> listeners = new ListenerList();

    public IndexTablePmBase(SimpleDocument searchModel) {
        Check.assertNotNull(searchModel);
        this.configs = IndexEntry.tableConfig;
        this.searchModel = searchModel;
        this.addSearchListener();
    }

    private void addSearchListener() {
        this.searchModel.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                IndexTablePmBase.this.notifySearchTextChanged(IndexTablePmBase.this.searchModel.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                IndexTablePmBase.this.notifySearchTextChanged(IndexTablePmBase.this.searchModel.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
    }

    public void notifySearchNext(boolean backwards) {
        for (IIndexTablePmListener listener : this.listeners) {
            listener.searchNext(backwards);
        }
    }

    private void notifySearchTextChanged(String text) {
        for (IIndexTablePmListener listener : this.listeners) {
            listener.searchTextChanged(text);
        }
    }

    public void notifyOpenCurrentSending() {
        for (IIndexTablePmListener listener : this.listeners) {
            listener.openCurrentSending();
        }
    }

    @Override
    public int getColumnCount() {
        return this.configs.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.configs[columnIndex].getColType();
    }

    @Override
    public String getColumnName(int column) {
        return this.configs[column].getColName();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public ITableAdapter[] getConfig() {
        return this.configs;
    }

    public void openSending(int row) {
        IndexEntry selected = this.getIndexEntry(row);
        Services.get(IAppService.class).requestOpenSending(selected);
    }

    @Override
    public INode<?> getValueAt(int rowIndex, int columnIndex) {
        return this.configs[columnIndex].getValue(this.getIndexEntry(rowIndex));
    }

    public abstract IndexEntry getIndexEntry(int var1);

    public Document getSearchModel() {
        return this.searchModel;
    }

    public void clearSearch() {
        this.searchModel.setText("");
    }

    public void add(IIndexTablePmListener listener) {
        this.listeners.add(listener);
    }
}

