/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.TimestampNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.ShowBordereauAsPdfJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ShowReceiptAsPdfJob;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import ch.transsoft.edec.util.SystemUtil;
import ch.transsoft.edec.util.evv.PdfWriter;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentUtil {
    private static final String ACCEPTANCE_TIME = "acceptanceTime";
    private static final String ACCEPTANCE_DATE = "acceptanceDate";
    private static final String DOCUMENT_TIME = "documentTime";
    private static final String DOCUMENT_DATE = "documentDate";
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    public static void showAL(IndexEntry entry) {
        if (!entry.getState().hasAl()) {
            return;
        }
        File path = SendingUtil.getAlPath(entry.getSendingId(), true);
        DocumentUtil.showAL(path);
    }

    public static void showAL(Sending sending) {
        if (!sending.getState().hasAl()) {
            return;
        }
        File path = SendingUtil.getAlPath(sending.getSendingId(), true);
        DocumentUtil.showAL(path);
    }

    public static void showAL(File path) {
        if (!path.exists()) {
            Services.get(ILoggingService.class).logAndReport(Services.getText(617) + " " + String.valueOf(path));
            return;
        }
        try {
            DocumentUtil.setWaitCursor();
            File temp = FileUtil.creatTempFile(path, "AL", "pdf");
            DocumentUtil.showDoc(temp);
        }
        finally {
            DocumentUtil.resetCursor();
        }
    }

    public static void showEvv(IndexEntry entry) {
        if (!entry.getState().hasEvv()) {
            return;
        }
        DocumentUtil.showEvv(entry.getSendingId());
    }

    public static void showEvv(Sending sending) {
        if (!sending.getState().hasEvv()) {
            return;
        }
        DocumentUtil.showEvv(sending.getSendingId());
    }

    public static void showEvv(String sendingId) {
        File evvPath = SendingUtil.getEvvPath(sendingId, true);
        DocumentUtil.showReceipt(evvPath);
    }

    public static void showReceipt(ReceiptEntry entry, ReceiptDocumentType type) {
        Services.get(IBackendService.class).jam(new ShowReceiptAsPdfJob(entry, type));
    }

    public static void showBordereau(BordereauEntry entry) {
        Services.get(IBackendService.class).jam(new ShowBordereauAsPdfJob(entry));
    }

    public static void showReceipt(File path) {
        try {
            DocumentUtil.setWaitCursor();
            File destPath = FileUtil.createTempFileName("Receipt", "pdf");
            PdfWriter.createReceipt(path, (OutputStream)new FileOutputStream(destPath));
            DocumentUtil.showDoc(destPath);
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(618));
        }
        finally {
            DocumentUtil.resetCursor();
        }
    }

    private static void setWaitCursor() {
        Services.get(IGuiService.class).setHourGlassCursor(true);
    }

    private static void resetCursor() {
        Services.get(IGuiService.class).setHourGlassCursor(false);
    }

    public static void showDoc(File path) {
        try {
            DocumentUtil.openFileWithNativeApp(path);
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(619));
        }
    }

    private static void openFileWithNativeApp(File path) throws IOException {
        if (SystemUtil.isOsWindows()) {
            String[] cmd = new String[]{"cmd.exe", "/C", "start", "\"Open file\"", "\"" + String.valueOf(path) + "\""};
            Runtime.getRuntime().exec(cmd);
        } else {
            Desktop.getDesktop().open(path);
        }
    }

    public static void openDirectory(File file) {
        try {
            DocumentUtil.openFileWithNativeApp(file);
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(620));
        }
    }

    public static <T> byte[] marshall(Class<T> type, T root) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance(type);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        marshaller.marshal(root, result);
        return result.toByteArray();
    }

    public static <T> T unmarshall(Class<T> type, byte[] data) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance(type);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (T)unmarshaller.unmarshal(new ByteArrayInputStream(data));
    }

    public static Document readXmlDoc(File file) throws ParserConfigurationException, SAXException, IOException {
        return DocumentUtil.readXmlDoc(new FileInputStream(file));
    }

    public static synchronized Document readXmlDoc(InputStream file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(file);
        return doc;
    }

    public static void openBrowser(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(621) + " ", url);
        }
    }

    public static void showPdf(byte[] data, String id) throws IOException {
        DocumentUtil.showPdf(new ByteArrayInputStream(data), id);
    }

    private static void showPdf(InputStream data, String id) throws IOException {
        try {
            DocumentUtil.setWaitCursor();
            File destPath = FileUtil.createTempFileName(id, "pdf");
            FileUtil.copy(data, destPath);
            DocumentUtil.showDoc(destPath);
        }
        finally {
            DocumentUtil.resetCursor();
        }
    }

    public static EdecDateNode getDocumentDate(Document doc) {
        NodeList tags = doc.getElementsByTagName(DOCUMENT_DATE);
        Check.assertTrue(tags.getLength() > 0, "Missing tag documentDate");
        return new EdecDateNode(tags.item(0).getTextContent());
    }

    public static void setAcceptanceDate(TimestampNode node, Document doc) {
        NodeList tags = doc.getElementsByTagName(ACCEPTANCE_DATE);
        if (tags.getLength() == 0) {
            return;
        }
        String dateStr = tags.item(0).getTextContent();
        String timeStr = null;
        tags = doc.getElementsByTagName(ACCEPTANCE_TIME);
        if (tags.getLength() == 1) {
            timeStr = tags.item(0).getTextContent();
        }
        node.setValue(DateUtil.getDate(dateStr, timeStr), false);
    }

    public static void setInteger(IntegralNode node, Element element, String tag) {
        NodeList tags = element.getElementsByTagName(tag);
        if (tags.getLength() == 0) {
            return;
        }
        String value = tags.item(0).getTextContent();
        node.setValue(Long.parseLong(value));
    }

    public static void setInteger(IntegralNode node, Document document, String tag) {
        NodeList tags = document.getElementsByTagName(tag);
        if (tags.getLength() == 0) {
            return;
        }
        String value = tags.item(0).getTextContent();
        node.setValue(Long.parseLong(value));
    }

    public static void setDecimal(DecimalNode node, Element element, String tag) {
        NodeList tags = element.getElementsByTagName(tag);
        if (tags.getLength() == 0) {
            return;
        }
        String value = tags.item(0).getTextContent();
        node.setValue(Double.parseDouble(value));
    }

    public static void setString(StringNode node, Element element, String tag) {
        NodeList tags = element.getElementsByTagName(tag);
        if (tags.getLength() == 0) {
            return;
        }
        String value = tags.item(0).getTextContent();
        node.setValue(value);
    }

    public static void setSelection(SelectionNode node, Element element, String tag) {
        NodeList tags = element.getElementsByTagName(tag);
        if (tags.getLength() == 0) {
            return;
        }
        String value = tags.item(0).getTextContent();
        node.setValue(value);
    }

    public static void setString(StringNode node, Document doc, String tag) {
        NodeList tags = doc.getElementsByTagName(tag);
        if (tags.getLength() == 0) {
            return;
        }
        String value = tags.item(0).getTextContent();
        node.setValue(value);
    }

    public static String getString(Document doc, String tag) {
        NodeList tags = doc.getElementsByTagName(tag);
        if (tags.getLength() == 0) {
            return null;
        }
        return tags.item(0).getTextContent();
    }
}

