/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.util.Check;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public class NumberUtil {
    public static final long ONE_MILLION = 1000000L;

    public static DecimalFormat createNumberFormat() {
        DecimalFormat result = (DecimalFormat)NumberFormat.getNumberInstance();
        DecimalFormatSymbols symbols = result.getDecimalFormatSymbols();
        symbols.setGroupingSeparator('\'');
        symbols.setDecimalSeparator('.');
        result.setDecimalFormatSymbols(symbols);
        return result;
    }

    public static DecimalFormat createIntegerFormat() {
        DecimalFormat result = (DecimalFormat)NumberFormat.getIntegerInstance();
        DecimalFormatSymbols symbols = result.getDecimalFormatSymbols();
        symbols.setGroupingSeparator('\'');
        result.setDecimalFormatSymbols(symbols);
        return result;
    }

    public static String format(int fractionDigits, Double value) {
        if (value == null) {
            return "";
        }
        DecimalFormat formatter = NumberUtil.createNumberFormat();
        ((NumberFormat)formatter).setMaximumFractionDigits(fractionDigits);
        ((NumberFormat)formatter).setMinimumFractionDigits(fractionDigits);
        ((NumberFormat)formatter).setMinimumIntegerDigits(1);
        return formatter.format(value);
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    public static int parseInteger(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e2) {
            throw Check.fail("Not a valid Integer: " + str);
        }
    }
}

