/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import java.util.Locale;

public enum OsName {
    WINDOWS,
    UNIX,
    MAC,
    OTHER;


    public static OsName getOsName() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            throw new RuntimeException("os.name not set");
        }
        if ((osName = osName.toLowerCase(Locale.ENGLISH)).contains("windows")) {
            return WINDOWS;
        }
        if (osName.contains("linux") || osName.contains("mpe/ix") || osName.contains("freebsd") || osName.contains("irix") || osName.contains("digital unix") || osName.contains("unix")) {
            return UNIX;
        }
        if (osName.contains("mac os")) {
            return MAC;
        }
        return OTHER;
    }

    public boolean isLinux() {
        return this == UNIX;
    }

    public boolean isOther() {
        return this == OTHER;
    }

    public static boolean isMacOs() {
        return OsName.getOsName().equals((Object)MAC);
    }
}

