/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.infra.XMLReader;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.ISendingHandler;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.IBordereauHandler;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.IImportSendingListHandler;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.regex.Pattern;

public class SendingUtil {
    public static final String SENDING_FILE_NAME = "sending.xml";
    public static final String AL_FILE_NAME = "al.pdf";
    public static final String EVV_FILE_NAME = "evv.xml";
    public static final String SIG_CHECK = "Signature Check";
    public static final String SIG_PROTOCOL_FILE_NAME = "eVV Signature Check.txt";
    public static final Pattern yearPattern = Pattern.compile("\\d{4}");
    public static final Pattern bordereauFileNamePatternGZ = Pattern.compile("^\\d+\\.xml\\.gz$");
    public static final Pattern bordereauFileNamePatternXML = Pattern.compile("^\\d+\\.xml$");
    public static final Pattern importSendingListFileNamePatternGZ = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}\\.xml\\.gz$");
    public static final Pattern importSendingListFileNamePatternXML = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}\\.xml$");

    public static String createSendingId(Sending sending) {
        File root = Services.get(IConfigService.class).getSendingDir(true);
        String yearPart = DateUtil.getSimpleDateFormat("yyyy").format(sending.getCreationDate().getValue());
        root = new File(root, yearPart);
        String sendingPart = DateUtil.getSimpleDateFormat("MM-dd-").format(sending.getCreationDate().getValue());
        return yearPart + "-" + SendingUtil.findNextAvailableId(root, sendingPart);
    }

    private static String findNextAvailableId(File root, String sending) {
        int i2 = 1;
        String sendingId;
        File path;
        while ((path = new File(root, sendingId = sending + Integer.toString(i2))).exists()) {
            ++i2;
        }
        return sendingId;
    }

    public static void forAllImportSendingLists(IImportSendingListHandler handler) {
        File root = SendingUtil.getReceiptDocDir(true);
        if (!root.exists()) {
            return;
        }
        String[] yearParts = root.list();
        if (yearParts == null) {
            return;
        }
        for (String yearPart : yearParts) {
            File yearPath;
            if (!yearPattern.matcher(yearPart).matches() || !(yearPath = new File(root, yearPart)).isDirectory()) continue;
            SendingUtil.handleImportSendingListsOfOneYear(handler, yearPath, Integer.parseInt(yearPart));
        }
    }

    public static void handleImportSendingListsOfOneYear(IImportSendingListHandler handler, File yearPath, int yearPart) {
        File[] files = yearPath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (importSendingListFileNamePatternGZ.matcher(file.getName()).matches()) {
                handler.handleGZ(file, yearPart);
            }
            if (!importSendingListFileNamePatternXML.matcher(file.getName()).matches()) continue;
            handler.handleXML(file, yearPart);
        }
    }

    public static void forAllBordereaus(IBordereauHandler handler) {
        File root = SendingUtil.getBordereauDocDir(true);
        if (!root.exists()) {
            return;
        }
        String[] yearParts = root.list();
        if (yearParts == null) {
            return;
        }
        for (String yearPart : yearParts) {
            File yearPath;
            if (!yearPattern.matcher(yearPart).matches() || !(yearPath = new File(root, yearPart)).isDirectory()) continue;
            SendingUtil.handleBordereausOfOneYear(handler, yearPath, Integer.parseInt(yearPart));
        }
    }

    private static void handleBordereausOfOneYear(IBordereauHandler handler, File yearPath, int yearPart) {
        File[] files = yearPath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (bordereauFileNamePatternGZ.matcher(file.getName()).matches()) {
                handler.handleGZ(file, yearPart);
            }
            if (!bordereauFileNamePatternXML.matcher(file.getName()).matches()) continue;
            handler.handleXML(file, yearPart);
        }
    }

    public static void forAllSendings(ISendingHandler handler) {
        File root = SendingUtil.getSendingsDir(true);
        if (!root.exists()) {
            return;
        }
        String[] yearParts = root.list();
        if (yearParts == null) {
            return;
        }
        for (String yearPart : yearParts) {
            File yearPath;
            if (!yearPattern.matcher(yearPart).matches() || !(yearPath = new File(root, yearPart)).isDirectory()) continue;
            SendingUtil.handleSendingsOfOneYear(handler, yearPath, yearPart);
        }
    }

    public static void handleSendingsOfOneYear(ISendingHandler handler, int year) {
        File root = SendingUtil.getSendingsDir(true);
        if (!root.exists()) {
            return;
        }
        String yearStr = Integer.toString(year);
        File yearPath = new File(root, yearStr);
        if (!yearPath.exists()) {
            return;
        }
        if (!yearPath.isDirectory()) {
            return;
        }
        SendingUtil.handleSendingsOfOneYear(handler, yearPath, yearStr);
    }

    private static void handleSendingsOfOneYear(ISendingHandler handler, File yearPath, String yearPart) {
        String[] sendingParts = yearPath.list();
        if (sendingParts == null) {
            return;
        }
        for (String sendingPart : sendingParts) {
            File sending = new File(yearPath, sendingPart);
            if (!sending.isDirectory()) continue;
            handler.handle(sending, new File(sending, SENDING_FILE_NAME), yearPart, sendingPart);
        }
    }

    public static File getSendingPath(String sendingId, boolean readOnly) {
        File path = SendingUtil.getSendingDir(sendingId, readOnly);
        return new File(path, SENDING_FILE_NAME);
    }

    public static File getBordereauInfoPathWithoutExtension(BordereauEntry entry, boolean readOnly) {
        File path = SendingUtil.getBordereauDir(entry, readOnly);
        return new File(path, entry.getBordereauNumber().getValue());
    }

    public static File getBordereauInfoPath(BordereauEntry entry, boolean readOnly) {
        File path = SendingUtil.getBordereauInfoPathWithoutExtension(entry, readOnly);
        return new File(path.getParentFile(), path.getName() + ".xml.gz");
    }

    public static File getImportSendingListPathWithoutExtension(EdecDateNode date, boolean readOnly) {
        File rootSeg = SendingUtil.getReceiptDocDir(readOnly);
        String yearsPart = Integer.toString(date.getYear());
        File result = new File(rootSeg, yearsPart);
        if (!readOnly) {
            result.mkdirs();
        }
        result = new File(result, date.getValue());
        return result;
    }

    public static File getImportSendingListPath(EdecDateNode date, boolean readOnly) {
        File path = SendingUtil.getImportSendingListPathWithoutExtension(date, readOnly);
        return new File(path.getParentFile(), path.getName() + ".xml.gz");
    }

    private static File getReceiptDocDir(boolean readOnly) {
        File rootSeg = Services.get(IConfigService.class).getReceiptDocsDir(readOnly);
        return rootSeg;
    }

    public static File getAlPath(StringNode sendingId, boolean readOnly) {
        return SendingUtil.getAlPath(sendingId.getValue(), readOnly);
    }

    public static File getAlPath(String sendingId, boolean readOnly) {
        File path = SendingUtil.getSendingDir(sendingId, readOnly);
        return new File(path, AL_FILE_NAME);
    }

    public static File getEvvPath(String sendingId, boolean readOnly) {
        File path = SendingUtil.getSendingDir(sendingId, readOnly);
        return new File(path, EVV_FILE_NAME);
    }

    public static int getYear(String sendingId) {
        return Integer.parseInt(sendingId.substring(0, 4));
    }

    public static File getSendingDir(String sendingId, boolean readOnly) {
        try {
            File rootSeg = SendingUtil.getSendingsDir(readOnly);
            String yearsPart = sendingId.substring(0, 4);
            String namePart = sendingId.substring(5, sendingId.length());
            File result = new File(rootSeg, yearsPart);
            result = new File(result, namePart);
            if (!readOnly) {
                result.mkdirs();
            }
            return result;
        }
        catch (Exception e2) {
            throw Check.fail(e2, "unexpected sendingId: " + sendingId);
        }
    }

    public static File getBordereauDir(BordereauEntry entry, boolean readOnly) {
        File rootSeg = SendingUtil.getBordereauDocDir(readOnly);
        String yearsPart = Integer.toString(entry.getCreationDate().getYear());
        File result = new File(rootSeg, yearsPart);
        if (!readOnly) {
            result.mkdirs();
        }
        return result;
    }

    private static File getBordereauDocDir(boolean readOnly) {
        File rootSeg = Services.get(IConfigService.class).getBordereauDocsDir(readOnly);
        return rootSeg;
    }

    public static File getReceiptDir(String customsReferenceNumber, Date bordereauCreationDate, boolean readOnly) {
        File rootSeg = SendingUtil.getReceiptDocDir(readOnly);
        String yearsPart = Integer.toString(DateUtil.getYear(bordereauCreationDate));
        File result = new File(rootSeg, yearsPart);
        result = new File(result, customsReferenceNumber);
        if (!readOnly) {
            result.mkdirs();
        }
        return result;
    }

    private static File getSendingsDir(boolean readOnly) {
        return Services.get(IConfigService.class).getSendingDir(readOnly);
    }

    public static Sending readSending(String sendingId, File file) throws Exception, FileNotFoundException {
        XMLReader reader = new XMLReader();
        Sending result = reader.read(new FileInputStream(file), Sending.class);
        result.setSendingId(sendingId);
        return result;
    }
}

