/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.util.DocumentUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaresWrapper {
    private static final int MAX_SESSION_AFFIRMATION_RETRIES = 10;
    private static final String BASE_URL = "https://xtares.admin.ch/tares";
    private static final String LOGIN_URL = "https://xtares.admin.ch/tares/login/loginFormFiller.do";
    private static final String FORM_URL = "https://xtares.admin.ch/tares/main/mainFormHandler.do";

    public static void openTares() {
        try {
            DocumentUtil.openBrowser(TaresWrapper.getUrl());
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(134));
        }
    }

    private static String getUrl() throws Exception {
        String sessionId = TaresWrapper.affirmSessionId();
        if (sessionId == null) {
            return BASE_URL;
        }
        return "https://xtares.admin.ch/tares/main/mainFormHandler.do;jsessionid=" + sessionId + "?kopfdaten.direction=export&l=" + Services.get(ITextService.class).getCurrentLanguage().name();
    }

    private static String affirmSessionId() throws Exception {
        String previousId = "";
        String currentId = "invalid";
        int sessionRetries = 0;
        while (!previousId.equals(currentId) && (currentId = TaresWrapper.renewSessionId(previousId = currentId)) != null && ++sessionRetries < 10) {
        }
        return currentId;
    }

    private static String renewSessionId(String sessionId) throws Exception {
        String result;
        URL url = URI.create("https://xtares.admin.ch/tares/login/loginFormFiller.do;jsessionid=" + sessionId).toURL();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            result = TaresWrapper.getSessionId(reader);
        }
        return result;
    }

    private static String getSessionId(BufferedReader reader) throws Exception {
        String line;
        Pattern regex = Pattern.compile(".*jsessionid=(.*)\\?.*");
        while ((line = reader.readLine()) != null) {
            Matcher matcher = regex.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

