/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.model.infra.IAddress;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.util.Check;
import java.awt.FontMetrics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextUtil {
    public static String cut(String text, FontMetrics metrics, int width) {
        return text.substring(0, TextUtil.getMaxIndex(metrics, text, width));
    }

    public static String cut(String str, int maxLength) {
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength - 2) + "..";
    }

    public static String toGetter(String name) {
        Check.assertFalse(name.isEmpty(), new Object[0]);
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static List<String> split(FontMetrics metrics, String str, int maxWidth) {
        return TextUtil.split(TextUtil.createMetrics(metrics), str, maxWidth);
    }

    public static List<String> split(Metrics metrics, String str, int maxWidth) {
        ArrayList<String> result = new ArrayList<String>();
        String current = str;
        while (!current.isEmpty()) {
            int max = TextUtil.getMaxIndex(metrics, current, maxWidth);
            result.add(current.substring(0, max));
            current = current.substring(max);
        }
        return result;
    }

    public static List<String> splitAtWhitespace(FontMetrics metrics, String str, int maxWidth) {
        return TextUtil.splitAtWhitespace(TextUtil.createMetrics(metrics), str, maxWidth);
    }

    public static List<String> splitAtWhitespace(Metrics metrics, String str, int maxWidth) {
        ArrayList<String> result = new ArrayList<String>();
        String current = str;
        while (!current.isEmpty()) {
            int max = TextUtil.getMaxIndexToNextWhitespace(metrics, current, maxWidth);
            if (max == 0) {
                max = TextUtil.getMaxIndex(metrics, current, maxWidth);
            }
            result.add(current.substring(0, max));
            current = current.substring(max);
        }
        return result;
    }

    private static int getMaxIndexToNextWhitespace(Metrics metrics, String str, int maxWidth) {
        int newLineIndex = str.indexOf("\n");
        if (newLineIndex != -1 && metrics.stringWidth(str.substring(0, newLineIndex)) <= maxWidth) {
            return newLineIndex + 1;
        }
        if (metrics.stringWidth(str) <= maxWidth) {
            return str.length();
        }
        int result = 0;
        while (result < str.length()) {
            int nextWS = TextUtil.getIndexOfNextWSOrEnd(str, result);
            if (nextWS == -1) {
                return result;
            }
            if (nextWS != 0 && metrics.stringWidth(str.substring(0, nextWS - 1)) >= maxWidth) {
                return result;
            }
            result = nextWS + 1;
        }
        return Math.min(str.length(), result);
    }

    private static int getIndexOfNextWSOrEnd(String str, int start) {
        int space = str.indexOf(32, start);
        if (space == -1) {
            return str.length();
        }
        return space;
    }

    public static int getMaxIndex(FontMetrics metrics, String str, int maxWidth) {
        return TextUtil.getMaxIndex(TextUtil.createMetrics(metrics), str, maxWidth);
    }

    public static int getMaxIndex(Metrics metrics, String str, int maxWidth) {
        int result = 0;
        while (result < str.length()) {
            if (metrics.stringWidth(str.substring(0, ++result)) < maxWidth) continue;
            return result;
        }
        return result;
    }

    public static String getStackTrace(Throwable e2) {
        if (e2 == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        e2.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static Metrics createMetrics(FontMetrics metrics) {
        return metrics::stringWidth;
    }

    public static String resolveFields(ModelNode<?> root, String input) {
        Matcher matcher = Pattern.compile("(\\{.*?\\})").matcher(input);
        StringBuilder result = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            result.append(input, start, matcher.start());
            String path = input.substring(matcher.start() + 1, matcher.end() - 1);
            TextUtil.appendFieldValue(root, path, result);
            start = matcher.end();
        }
        result.append(input.substring(start, input.length()));
        return result.toString();
    }

    private static void appendFieldValue(ModelNode<?> root, String path, StringBuilder result) {
        try {
            INode<?> node = root.find(path);
            if (node instanceof IAddress) {
                ((IAddress)((Object)node)).getAddress().apply(result, "\n");
                return;
            }
            result.append(node.toString());
        }
        catch (Exception e2) {
            result.append("{" + path + "}");
        }
    }

    public static interface Metrics {
        public int stringWidth(String var1);
    }
}

