/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.service.ezv.evv.sigcheck.util.NamespaceContextImpl;
import ch.transsoft.edec.util.Check;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static volatile DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    public static Document read(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.parse(is);
    }

    public static Node extractX509Token(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl nsc = new NamespaceContextImpl();
        xpath.setNamespaceContext(nsc);
        XPathExpression expr = xpath.compile("//wsse:Security/wsse:BinarySecurityToken");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractDSignature(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl nsc = new NamespaceContextImpl();
        xpath.setNamespaceContext(nsc);
        XPathExpression expr = xpath.compile("//wsse:Security/ds:Signature");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractTimeStamp(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl nsc = new NamespaceContextImpl();
        xpath.setNamespaceContext(nsc);
        XPathExpression expr = xpath.compile("//wsu:Timestamp/wsu:Created");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractDocumentInformation(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//*[local-name()='documentInformation']");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractTraderDeclarationNumber(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//*[local-name()='traderDeclarationNumber']");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node extractTraderReference(Document xmldoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//*[local-name()='traderReference']");
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static Node findNode(Node xmldoc, String path) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl nsc = new NamespaceContextImpl();
        xpath.setNamespaceContext(nsc);
        XPathExpression expr = xpath.compile(path);
        return (Node)expr.evaluate(xmldoc, XPathConstants.NODE);
    }

    public static NodeList findNodes(Node xmldoc, String path) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl nsc = new NamespaceContextImpl();
        xpath.setNamespaceContext(nsc);
        XPathExpression expr = xpath.compile(path);
        return (NodeList)expr.evaluate(xmldoc, XPathConstants.NODESET);
    }

    public static XPathExpression createExpression(String path) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            return xpath.compile(path);
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }

    public static String getString(Node node, XPathExpression expression) throws Exception {
        if (node == null) {
            return "";
        }
        return (String)expression.evaluate(node, XPathConstants.STRING);
    }

    public static String getString(Node node, String path) throws Exception {
        return XMLUtil.getString(node, XMLUtil.createExpression(path));
    }

    public static Double getDouble(Node item, String path) throws NumberFormatException, Exception {
        String string = XMLUtil.getString(item, path);
        if (string.isEmpty()) {
            return null;
        }
        return Double.parseDouble(string);
    }
}

