/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util.evv;

import ch.transsoft.edec.util.BarcodeUtil;
import ch.transsoft.edec.util.Check;
import com.lowagie.text.Image;
import java.net.URL;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextUserAgent;
import org.xhtmlrenderer.resource.ImageResource;

public class EdecUserAgent
extends ITextUserAgent {
    public EdecUserAgent(ITextOutputDevice outputDevice) {
        super(outputDevice);
    }

    @Override
    public ImageResource getImageResource(String uri) {
        try {
            Image image = this.getImage(uri);
            this.scaleToOutputResolution(image);
            return new ImageResource(null, new ITextFSImage(image));
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }

    private Image getImage(String uri) throws Exception {
        if (uri.startsWith("barcode")) {
            String documentId = uri.replaceFirst("barcode/", "");
            return Image.getInstance(BarcodeUtil.getBarcodeImage(documentId));
        }
        URL resource = this.getClass().getResource(uri);
        Check.assertNotNull(resource, "Image not found: " + uri);
        return Image.getInstance(resource);
    }

    private void scaleToOutputResolution(Image image) {
        float factor = this.getSharedContext().getDotsPerPixel();
        image.scaleAbsolute(image.getPlainWidth() * factor, image.getPlainHeight() * factor);
    }
}

