/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util.evv;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.evv.EdecUserAgent;
import com.lowagie.text.DocumentException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.PrettyXmlSerializer;
import org.htmlcleaner.TagNode;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PdfWriter {
    private static final String STYLE_BORDEREAU_XSLT = "style_bordereau.xslt";
    private static final String STYLE_RECEIPT_XSLT_V1 = "edecReceiptResponse_stylesheet_v_1_0.xslt";
    private static final String STYLE_RECEIPT_XSLT_V2 = "edecReceiptResponse_stylesheet_v_2_0.xslt";
    private static final String STYLE_RECEIPT_XSLT_V3 = "edecReceiptResponse_stylesheet_v_3_0.xslt";
    private ITextRenderer renderer = this.createRenderer();
    private OutputStream os;

    public static void createReceipt(File input, OutputStream output) throws Exception {
        Check.assertTrue(input.exists(), Services.getText(617) + " " + String.valueOf(input));
        PdfWriter.createReceipt(new FileInputStream(input), output);
    }

    public static void createReceipt(InputStream input, OutputStream output) throws Exception {
        Document doc = PdfWriter.createDoc(input);
        String xslt = PdfWriter.getEvvXSLT(doc);
        new PdfWriter().createPdf(doc, output, PdfWriter.class.getResourceAsStream(xslt));
    }

    public static void createBordereau(InputStream input, OutputStream output) throws Exception {
        new PdfWriter().createPdf(PdfWriter.createDoc(input), output, PdfWriter.class.getResourceAsStream(STYLE_BORDEREAU_XSLT));
    }

    public void addBordereau(InputStream input, OutputStream output) throws Exception {
        StringBuffer result = this.transform(PdfWriter.createDoc(input), PdfWriter.class.getResourceAsStream(STYLE_BORDEREAU_XSLT));
        byte[] data = this.tidyXHTML(result);
        this.addFirstPage(data, output);
    }

    public void addReceipt(InputStream input) throws Exception {
        Document doc = PdfWriter.createDoc(input);
        String xslt = PdfWriter.getEvvXSLT(doc);
        StringBuffer result = this.transform(doc, PdfWriter.class.getResourceAsStream(xslt));
        byte[] data = this.tidyXHTML(result);
        this.addNextPage(data);
    }

    private static Document createDoc(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document doc = builder.parse(input);
        return doc;
    }

    private static String getEvvXSLT(Document doc) {
        NodeList el = doc.getElementsByTagName("ns1:receiptRequestResponse");
        String schemaVersion = el.item(0).getAttributes().getNamedItem("schemaVersion").getTextContent();
        if (schemaVersion.equals("0.4") || schemaVersion.equals("0.5") || schemaVersion.equals("0.6") || schemaVersion.equals("1.0")) {
            return STYLE_RECEIPT_XSLT_V1;
        }
        if (schemaVersion.equals("2.0")) {
            return STYLE_RECEIPT_XSLT_V2;
        }
        return STYLE_RECEIPT_XSLT_V3;
    }

    public void createPdf(Document input, OutputStream output, InputStream xslt) throws Exception {
        StringBuffer result = this.transform(input, xslt);
        byte[] evvXhtml = this.tidyXHTML(result);
        this.toPDF(evvXhtml, output);
    }

    private StringBuffer transform(Document doc, InputStream xslt) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource source = new StreamSource(xslt);
        Transformer transformer = factory.newTransformer(source);
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.getBuffer();
    }

    public byte[] tidyXHTML(StringBuffer input) throws Exception {
        HtmlCleaner cleaner = new HtmlCleaner();
        CleanerProperties props = cleaner.getProperties();
        props.setUseCdataForScriptAndStyle(true);
        props.setRecognizeUnicodeChars(true);
        props.setUseEmptyElementTags(true);
        props.setAdvancedXmlEscape(true);
        props.setTranslateSpecialEntities(true);
        props.setBooleanAttributeValues("empty");
        TagNode node = cleaner.clean(new StringReader(input.toString()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrettyXmlSerializer prettyXmlSerializer = new PrettyXmlSerializer(props);
        prettyXmlSerializer.writeXmlToStream(node, out, "UTF-8");
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toPDF(byte[] evvXhtml, OutputStream os) throws Exception {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(evvXhtml));
            this.htmlToPDF(os, doc);
        }
        finally {
            FileUtil.close(os);
        }
    }

    public void htmlToPDF(OutputStream os, Document doc) throws DocumentException, IOException {
        this.renderer.setDocument(doc, null);
        this.renderer.layout();
        this.renderer.createPDF(os);
        os.flush();
    }

    public void addFirstPage(byte[] evvXhtml, OutputStream os) throws Exception {
        this.os = os;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(evvXhtml));
        this.renderer.setDocument(doc, null);
        this.renderer.layout();
        this.renderer.createPDF(os, false);
    }

    public void addNextPage(byte[] evvXhtml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(evvXhtml), StandardCharsets.UTF_8)));
        this.renderer.setDocument(doc, null);
        this.renderer.layout();
        this.renderer.writeNextDocument();
    }

    public void finish() throws Exception {
        this.renderer.finishPDF();
        this.os.flush();
        FileUtil.close(this.os);
    }

    private ITextRenderer createRenderer() {
        ITextRenderer renderer = new ITextRenderer(53.333332f, 34);
        EdecUserAgent userAgent = new EdecUserAgent(renderer.getOutputDevice());
        userAgent.setSharedContext(renderer.getSharedContext());
        renderer.getSharedContext().setUserAgentCallback(userAgent);
        return renderer;
    }

    private void writeTOFile(byte[] evvXhtml) {
        String x = new String(evvXhtml);
        System.out.println(x);
    }
}

