/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.io.BaseReader;
import java.io.IOException;
import java.io.InputStream;

public final class ISOLatinReader
extends BaseReader {
    boolean mXml11 = false;
    int mByteCount = 0;

    public ISOLatinReader(ReaderConfig cfg, InputStream in, byte[] buf, int ptr, int len, boolean recycleBuffer) {
        super(cfg, in, buf, ptr, len, recycleBuffer);
    }

    @Override
    public void setXmlCompliancy(int xmlVersion) {
        this.mXml11 = xmlVersion == 272;
    }

    @Override
    public int read(char[] cbuf, int start, int len) throws IOException {
        if (start < 0 || start + len > cbuf.length) {
            this.reportBounds(cbuf, start, len);
        }
        if (this.mByteBuffer == null) {
            return -1;
        }
        if (len < 1) {
            return 0;
        }
        int avail = this.mByteBufferEnd - this.mBytePtr;
        if (avail <= 0) {
            this.mByteCount += this.mByteBufferEnd;
            int count = this.readBytes();
            if (count <= 0) {
                if (count == 0) {
                    this.reportStrangeStream();
                }
                this.freeBuffers();
                return -1;
            }
            avail = count;
        }
        if (len > avail) {
            len = avail;
        }
        int i2 = this.mBytePtr;
        int last = i2 + len;
        if (this.mXml11) {
            while (i2 < last) {
                int c2;
                if ((c2 = (int)(this.mByteBuffer[i2++] & 0xFF)) >= 127 && c2 <= 159) {
                    if (c2 == 133) {
                        c2 = 10;
                    } else {
                        int pos = this.mByteCount + i2;
                        this.reportInvalidXml11(c2, pos, pos);
                    }
                }
                cbuf[start++] = c2;
            }
        } else {
            while (i2 < last) {
                cbuf[start++] = (char)(this.mByteBuffer[i2++] & 0xFF);
            }
        }
        this.mBytePtr = last;
        return len;
    }
}

