/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.util.XmlChars;

public class WstxInputData {
    public static final char CHAR_NULL = '\u0000';
    public static final char INT_NULL = '\u0000';
    public static final char CHAR_SPACE = ' ';
    public static final char INT_SPACE = ' ';
    public static final int MAX_UNICODE_CHAR = 0x10FFFF;
    private static final int VALID_CHAR_COUNT = 256;
    private static final byte NAME_CHAR_INVALID_B = 0;
    private static final byte NAME_CHAR_ALL_VALID_B = 1;
    private static final byte NAME_CHAR_VALID_NONFIRST_B = -1;
    private static final byte[] sCharValidity;
    private static final int VALID_PUBID_CHAR_COUNT = 128;
    private static final byte[] sPubidValidity;
    private static final byte PUBID_CHAR_VALID_B = 1;
    protected boolean mXml11 = false;
    protected char[] mInputBuffer;
    protected int mInputPtr = 0;
    protected int mInputEnd = 0;
    protected long mCurrInputProcessed = 0L;
    protected int mCurrInputRow = 1;
    protected int mCurrInputRowStart = 0;

    protected WstxInputData() {
    }

    public void copyBufferStateFrom(WstxInputData src) {
        this.mInputBuffer = src.mInputBuffer;
        this.mInputPtr = src.mInputPtr;
        this.mInputEnd = src.mInputEnd;
        this.mCurrInputProcessed = src.mCurrInputProcessed;
        this.mCurrInputRow = src.mCurrInputRow;
        this.mCurrInputRowStart = src.mCurrInputRowStart;
    }

    protected final boolean isNameStartChar(char c2) {
        if (c2 <= 'z') {
            if (c2 >= 'a') {
                return true;
            }
            if (c2 < 'A') {
                return false;
            }
            return c2 <= 'Z' || c2 == '_';
        }
        return this.mXml11 ? XmlChars.is11NameStartChar(c2) : XmlChars.is10NameStartChar(c2);
    }

    protected final boolean isNameChar(char c2) {
        if (c2 <= 'z') {
            if (c2 >= 'a') {
                return true;
            }
            if (c2 <= 'Z') {
                if (c2 >= 'A') {
                    return true;
                }
                return c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-';
            }
            return c2 == '_';
        }
        return this.mXml11 ? XmlChars.is11NameChar(c2) : XmlChars.is10NameChar(c2);
    }

    public static final boolean isNameStartChar(char c2, boolean nsAware, boolean xml11) {
        if (c2 <= 'z') {
            if (c2 >= 'a') {
                return true;
            }
            if (c2 < 'A') {
                return c2 == ':' && !nsAware;
            }
            return c2 <= 'Z' || c2 == '_';
        }
        return xml11 ? XmlChars.is11NameStartChar(c2) : XmlChars.is10NameStartChar(c2);
    }

    public static final boolean isNameChar(char c2, boolean nsAware, boolean xml11) {
        if (c2 <= 'z') {
            if (c2 >= 'a') {
                return true;
            }
            if (c2 <= 'Z') {
                if (c2 >= 'A') {
                    return true;
                }
                return c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == ':' && !nsAware;
            }
            return c2 == '_';
        }
        return xml11 ? XmlChars.is11NameChar(c2) : XmlChars.is10NameChar(c2);
    }

    public static final int findIllegalNameChar(String name, boolean nsAware, boolean xml11) {
        int len = name.length();
        if (len < 1) {
            return -1;
        }
        char c2 = name.charAt(0);
        if (c2 <= 'z' ? c2 < 'a' && (c2 < 'A' ? c2 != ':' || nsAware : c2 > 'Z' && c2 != '_') : (xml11 ? !XmlChars.is11NameStartChar(c2) : !XmlChars.is10NameStartChar(c2))) {
            return 0;
        }
        for (int i2 = 1; i2 < len; ++i2) {
            c2 = name.charAt(i2);
            if (c2 <= 'z' ? c2 >= 'a' || (c2 <= 'Z' ? c2 >= 'A' || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == ':' && !nsAware : c2 == '_') : (xml11 ? XmlChars.is11NameChar(c2) : XmlChars.is10NameChar(c2))) continue;
            return i2;
        }
        return -1;
    }

    public static final int findIllegalNmtokenChar(String nmtoken, boolean nsAware, boolean xml11) {
        int len = nmtoken.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c2 = nmtoken.charAt(i2);
            if (c2 <= 'z' ? c2 >= 'a' || (c2 <= 'Z' ? c2 >= 'A' || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == ':' && !nsAware : c2 == '_') : (xml11 ? XmlChars.is11NameChar(c2) : XmlChars.is10NameChar(c2))) continue;
            return i2;
        }
        return -1;
    }

    public static final boolean isSpaceChar(char c2) {
        return c2 <= ' ';
    }

    public static String getCharDesc(char c2) {
        char i2 = c2;
        if (Character.isISOControl(c2)) {
            return "(CTRL-CHAR, code " + i2 + ")";
        }
        if (i2 > '\u00ff') {
            return "'" + c2 + "' (code " + i2 + " / 0x" + Integer.toHexString(i2) + ")";
        }
        return "'" + c2 + "' (code " + i2 + ")";
    }

    static {
        int i2;
        sCharValidity = new byte[256];
        WstxInputData.sCharValidity[95] = 1;
        int last = 25;
        for (i2 = 0; i2 <= last; ++i2) {
            WstxInputData.sCharValidity[65 + i2] = 1;
            WstxInputData.sCharValidity[97 + i2] = 1;
        }
        for (i2 = 192; i2 < 256; ++i2) {
            WstxInputData.sCharValidity[i2] = 1;
        }
        WstxInputData.sCharValidity[215] = 0;
        WstxInputData.sCharValidity[247] = 0;
        WstxInputData.sCharValidity[45] = -1;
        WstxInputData.sCharValidity[46] = -1;
        WstxInputData.sCharValidity[183] = -1;
        for (i2 = 48; i2 <= 57; ++i2) {
            WstxInputData.sCharValidity[i2] = -1;
        }
        sPubidValidity = new byte[128];
        last = 25;
        for (i2 = 0; i2 <= last; ++i2) {
            WstxInputData.sPubidValidity[65 + i2] = 1;
            WstxInputData.sPubidValidity[97 + i2] = 1;
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            WstxInputData.sPubidValidity[i2] = 1;
        }
        WstxInputData.sPubidValidity[10] = 1;
        WstxInputData.sPubidValidity[13] = 1;
        WstxInputData.sPubidValidity[32] = 1;
        WstxInputData.sPubidValidity[45] = 1;
        WstxInputData.sPubidValidity[39] = 1;
        WstxInputData.sPubidValidity[40] = 1;
        WstxInputData.sPubidValidity[41] = 1;
        WstxInputData.sPubidValidity[43] = 1;
        WstxInputData.sPubidValidity[44] = 1;
        WstxInputData.sPubidValidity[46] = 1;
        WstxInputData.sPubidValidity[47] = 1;
        WstxInputData.sPubidValidity[58] = 1;
        WstxInputData.sPubidValidity[61] = 1;
        WstxInputData.sPubidValidity[63] = 1;
        WstxInputData.sPubidValidity[59] = 1;
        WstxInputData.sPubidValidity[33] = 1;
        WstxInputData.sPubidValidity[42] = 1;
        WstxInputData.sPubidValidity[35] = 1;
        WstxInputData.sPubidValidity[64] = 1;
        WstxInputData.sPubidValidity[36] = 1;
        WstxInputData.sPubidValidity[95] = 1;
        WstxInputData.sPubidValidity[37] = 1;
    }
}

