/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    public static final float RIGHT_LIMIT = 20000.0f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float[] extraHeights;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] canvasesPos;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
        this.initExtraHeights();
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (pdfPRow.cells[i2] == null) continue;
            this.cells[i2] = new PdfPCell(pdfPRow.cells[i2]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
        this.initExtraHeights();
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f2 = 0.0f;
        this.calculated = false;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            PdfPCell pdfPCell = this.cells[i2];
            if (pdfPCell == null) {
                f2 += fArray[i2];
                continue;
            }
            pdfPCell.setLeft(f2);
            int n = i2 + pdfPCell.getColspan();
            while (i2 < n) {
                f2 += fArray[i2];
                ++i2;
            }
            --i2;
            pdfPCell.setRight(f2);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public void initExtraHeights() {
        this.extraHeights = new float[this.cells.length];
        for (int i2 = 0; i2 < this.extraHeights.length; ++i2) {
            this.extraHeights[i2] = 0.0f;
        }
    }

    public void setExtraHeight(int n, float f2) {
        if (n < 0 || n >= this.cells.length) {
            return;
        }
        this.extraHeights[n] = f2;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            PdfPCell pdfPCell = this.cells[i2];
            float f2 = 0.0f;
            if (pdfPCell == null || !((f2 = pdfPCell.getMaxHeight()) > this.maxHeight) || pdfPCell.getRowspan() != 1) continue;
            this.maxHeight = f2;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float f2, float f3, float f4, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        Color color = pdfPCell.getBackgroundColor();
        if (color != null || pdfPCell.hasBorders()) {
            Object object;
            float f5 = pdfPCell.getRight() + f2;
            float f6 = pdfPCell.getTop() + f3;
            float f7 = pdfPCell.getLeft() + f2;
            float f8 = f6 - f4;
            if (color != null) {
                object = pdfContentByteArray[1];
                ((PdfContentByte)object).setColorFill(color);
                ((PdfContentByte)object).rectangle(f7, f8, f5 - f7, f6 - f8);
                ((PdfContentByte)object).fill();
            }
            if (pdfPCell.hasBorders()) {
                object = new Rectangle(f7, f8, f5, f6);
                ((Rectangle)object).cloneNonPositionParameters(pdfPCell);
                ((Rectangle)object).setBackgroundColor(null);
                PdfContentByte pdfContentByte = pdfContentByteArray[2];
                pdfContentByte.rectangle((Rectangle)object);
            }
        }
    }

    protected void saveAndRotateCanvases(PdfContentByte[] pdfContentByteArray, float f2, float f3, float f4, float f5, float f6, float f7) {
        int n = 4;
        if (this.canvasesPos == null) {
            this.canvasesPos = new int[n * 2];
        }
        for (int i2 = 0; i2 < n; ++i2) {
            ByteBuffer byteBuffer = pdfContentByteArray[i2].getInternalBuffer();
            this.canvasesPos[i2 * 2] = byteBuffer.size();
            pdfContentByteArray[i2].saveState();
            pdfContentByteArray[i2].concatCTM(f2, f3, f4, f5, f6, f7);
            this.canvasesPos[i2 * 2 + 1] = byteBuffer.size();
        }
    }

    protected void restoreCanvases(PdfContentByte[] pdfContentByteArray) {
        int n = 4;
        for (int i2 = 0; i2 < n; ++i2) {
            ByteBuffer byteBuffer = pdfContentByteArray[i2].getInternalBuffer();
            int n2 = byteBuffer.size();
            pdfContentByteArray[i2].restoreState();
            if (n2 != this.canvasesPos[i2 * 2 + 1]) continue;
            byteBuffer.setSize(this.canvasesPos[i2 * 2]);
        }
    }

    public static float setColumn(ColumnText columnText, float f2, float f3, float f4, float f5) {
        if (f2 > f4) {
            f4 = f2;
        }
        if (f3 > f5) {
            f5 = f3;
        }
        columnText.setSimpleColumn(f2, f3, f4, f5);
        return f5;
    }

    public void writeCells(int n, int n2, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        int n3;
        if (!this.calculated) {
            this.calculateHeights();
        }
        n2 = n2 < 0 ? this.cells.length : Math.min(n2, this.cells.length);
        if (n < 0) {
            n = 0;
        }
        if (n >= n2) {
            return;
        }
        for (n3 = n; n3 >= 0 && this.cells[n3] == null; --n3) {
            if (n3 <= 0) continue;
            f2 -= this.widths[n3 - 1];
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (this.cells[n3] != null) {
            f2 -= this.cells[n3].getLeft();
        }
        for (int i2 = n3; i2 < n2; ++i2) {
            float f4;
            float f5;
            float f6;
            PdfPCell pdfPCell = this.cells[i2];
            if (pdfPCell == null) continue;
            float f7 = this.maxHeight + this.extraHeights[i2];
            this.writeBorderAndBackground(f2, f3, f7, pdfPCell, pdfContentByteArray);
            Image image = pdfPCell.getImage();
            float f8 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
            if (pdfPCell.getHeight() <= f7) {
                switch (pdfPCell.getVerticalAlignment()) {
                    case 6: {
                        f8 = pdfPCell.getTop() + f3 - f7 + pdfPCell.getHeight() - pdfPCell.getEffectivePaddingTop();
                        break;
                    }
                    case 5: {
                        f8 = pdfPCell.getTop() + f3 + (pdfPCell.getHeight() - f7) / 2.0f - pdfPCell.getEffectivePaddingTop();
                        break;
                    }
                }
            }
            if (image != null) {
                if (pdfPCell.getRotation() != 0) {
                    image = Image.getInstance(image);
                    image.setRotation(image.getImageRotation() + (float)((double)pdfPCell.getRotation() * Math.PI / 180.0));
                }
                boolean bl = false;
                if (pdfPCell.getHeight() > f7) {
                    image.scalePercent(100.0f);
                    f6 = (f7 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom()) / image.getScaledHeight();
                    image.scalePercent(f6 * 100.0f);
                    bl = true;
                }
                f6 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                if (bl) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f6 = f2 + (pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft() + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            f6 = f2 + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth();
                            break;
                        }
                    }
                    f8 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                }
                image.setAbsolutePosition(f6, f8 - image.getScaledHeight());
                try {
                    pdfContentByteArray[3].addImage(image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                float f9 = f7 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom();
                f6 = pdfPCell.getWidth() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight();
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                columnText.setSimpleColumn(0.0f, 0.0f, f9 + 0.001f, -f6);
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f10 = -columnText.getYLine();
                if (f9 <= 0.0f || f6 <= 0.0f) {
                    f10 = 0.0f;
                }
                if (f10 > 0.0f) {
                    if (pdfPCell.isUseDescender()) {
                        f10 -= columnText.getDescender();
                    }
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                    columnText.setCanvases(pdfContentByteArray);
                    columnText.setSimpleColumn(-0.003f, -0.001f, f9 + 0.003f, f10);
                    if (pdfPCell.getRotation() == 90) {
                        f5 = pdfPCell.getTop() + f3 - f7 + pdfPCell.getEffectivePaddingBottom();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight();
                                break;
                            }
                            case 5: {
                                f4 = pdfPCell.getLeft() + f2 + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() + f10) / 2.0f;
                                break;
                            }
                            default: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft() + f10;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, 1.0f, -1.0f, 0.0f, f4, f5);
                    } else {
                        f5 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                                break;
                            }
                            case 5: {
                                f4 = pdfPCell.getLeft() + f2 + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() - f10) / 2.0f;
                                break;
                            }
                            default: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight() - f10;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, -1.0f, 1.0f, 0.0f, f4, f5);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        this.restoreCanvases(pdfContentByteArray);
                    }
                }
            } else {
                float f11 = pdfPCell.getFixedHeight();
                f6 = pdfPCell.getRight() + f2 - pdfPCell.getEffectivePaddingRight();
                float f12 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                if (pdfPCell.isNoWrap()) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f6 += 10000.0f;
                            f12 -= 10000.0f;
                            break;
                        }
                        case 2: {
                            if (pdfPCell.getRotation() == 180) {
                                f6 += 20000.0f;
                                break;
                            }
                            f12 -= 20000.0f;
                            break;
                        }
                        default: {
                            if (pdfPCell.getRotation() == 180) {
                                f12 -= 20000.0f;
                                break;
                            }
                            f6 += 20000.0f;
                        }
                    }
                }
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                f4 = f8 - (f7 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom());
                if (f11 > 0.0f && pdfPCell.getHeight() > f7) {
                    f8 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                    f4 = pdfPCell.getTop() + f3 - f7 + pdfPCell.getEffectivePaddingBottom();
                }
                if ((f8 > f4 || columnText.zeroHeightElement()) && f12 < f6) {
                    columnText.setSimpleColumn(f12, f4 - 0.001f, f6, f8);
                    if (pdfPCell.getRotation() == 180) {
                        f5 = f12 + f6;
                        float f13 = f3 + f3 - f7 + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getEffectivePaddingTop();
                        this.saveAndRotateCanvases(pdfContentByteArray, -1.0f, 0.0f, 0.0f, -1.0f, f5, f13);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        if (pdfPCell.getRotation() == 180) {
                            this.restoreCanvases(pdfContentByteArray);
                        }
                    }
                }
            }
            PdfPCellEvent pdfPCellEvent = pdfPCell.getCellEvent();
            if (pdfPCellEvent == null) continue;
            Rectangle rectangle = new Rectangle(pdfPCell.getLeft() + f2, pdfPCell.getTop() + f3 - f7, pdfPCell.getRight() + f2, pdfPCell.getTop() + f3);
            pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f2) {
        this.maxHeight = f2;
    }

    float[] getEventWidth(float f2) {
        int n = 0;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.cells[i2] == null) continue;
            ++n;
        }
        float[] fArray = new float[n + 1];
        n = 0;
        fArray[n++] = f2;
        for (int i3 = 0; i3 < this.cells.length; ++i3) {
            if (this.cells[i3] == null) continue;
            fArray[n] = fArray[n - 1] + this.cells[i3].getWidth();
            ++n;
        }
        return fArray;
    }

    public PdfPRow splitRow(PdfPTable pdfPTable, int n, float f2) {
        int n2;
        PdfPCell[] pdfPCellArray = new PdfPCell[this.cells.length];
        float[] fArray = new float[this.cells.length];
        float[] fArray2 = new float[this.cells.length];
        boolean bl = true;
        for (n2 = 0; n2 < this.cells.length; ++n2) {
            Object object;
            float f3 = f2;
            PdfPCell pdfPCell = this.cells[n2];
            if (pdfPCell == null) {
                int n3 = n;
                if (!pdfPTable.rowSpanAbove(n3, n2)) continue;
                f3 += pdfPTable.getRowHeight(n3);
                while (pdfPTable.rowSpanAbove(--n3, n2)) {
                    f3 += pdfPTable.getRowHeight(n3);
                }
                object = pdfPTable.getRow(n3);
                if (object == null || ((PdfPRow)object).getCells()[n2] == null) continue;
                pdfPCellArray[n2] = new PdfPCell(((PdfPRow)object).getCells()[n2]);
                pdfPCellArray[n2].consumeHeight(f3);
                pdfPCellArray[n2].setRowspan(((PdfPRow)object).getCells()[n2].getRowspan() - n + n3);
                bl = false;
                continue;
            }
            fArray[n2] = pdfPCell.getFixedHeight();
            fArray2[n2] = pdfPCell.getMinimumHeight();
            Image image = pdfPCell.getImage();
            object = new PdfPCell(pdfPCell);
            if (image != null) {
                if (f3 > pdfPCell.getEffectivePaddingBottom() + pdfPCell.getEffectivePaddingTop() + 2.0f) {
                    ((PdfPCell)object).setPhrase(null);
                    bl = false;
                }
            } else {
                boolean bl2;
                int n4;
                float f4;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                float f5 = pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft();
                float f6 = pdfPCell.getTop() + pdfPCell.getEffectivePaddingBottom() - f3;
                float f7 = pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight();
                float f8 = pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop();
                switch (pdfPCell.getRotation()) {
                    case 90: 
                    case 270: {
                        f4 = PdfPRow.setColumn(columnText, f6, f5, f8, f7);
                        break;
                    }
                    default: {
                        f4 = PdfPRow.setColumn(columnText, f5, f6, pdfPCell.isNoWrap() ? 20000.0f : f7, f8);
                    }
                }
                try {
                    n4 = columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                boolean bl3 = bl2 = columnText.getYLine() == f4;
                if (bl2) {
                    ((PdfPCell)object).setColumn(ColumnText.duplicate(pdfPCell.getColumn()));
                    columnText.setFilledWidth(0.0f);
                } else if ((n4 & 1) == 0) {
                    ((PdfPCell)object).setColumn(columnText);
                    columnText.setFilledWidth(0.0f);
                } else {
                    ((PdfPCell)object).setPhrase(null);
                }
                bl = bl && bl2;
            }
            pdfPCellArray[n2] = object;
            pdfPCell.setFixedHeight(f3);
        }
        if (bl) {
            for (n2 = 0; n2 < this.cells.length; ++n2) {
                PdfPCell pdfPCell = this.cells[n2];
                if (pdfPCell == null) continue;
                if (fArray[n2] > 0.0f) {
                    pdfPCell.setFixedHeight(fArray[n2]);
                    continue;
                }
                pdfPCell.setMinimumHeight(fArray2[n2]);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow pdfPRow = new PdfPRow(pdfPCellArray);
        pdfPRow.widths = (float[])this.widths.clone();
        pdfPRow.calculateHeights();
        return pdfPRow;
    }

    public PdfPCell[] getCells() {
        return this.cells;
    }
}

