/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TIFFField;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class TIFFDirectory
implements Serializable {
    private static final long serialVersionUID = -168636766193675380L;
    boolean isBigEndian;
    int numEntries;
    TIFFField[] fields;
    Hashtable fieldIndex = new Hashtable();
    long IFDOffset = 8L;
    long nextIFDOffset = 0L;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int n) {
        return n == 18761 || n == 19789;
    }

    public TIFFDirectory(RandomAccessFileOrArray randomAccessFileOrArray, int n) throws IOException {
        long l2 = randomAccessFileOrArray.getFilePointer();
        randomAccessFileOrArray.seek(0L);
        int n2 = randomAccessFileOrArray.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        this.isBigEndian = n2 == 19789;
        int n3 = this.readUnsignedShort(randomAccessFileOrArray);
        if (n3 != 42) {
            throw new IllegalArgumentException("Bad magic number, should be 42.");
        }
        long l3 = this.readUnsignedInt(randomAccessFileOrArray);
        for (int i2 = 0; i2 < n; ++i2) {
            if (l3 == 0L) {
                throw new IllegalArgumentException("Directory number too large.");
            }
            randomAccessFileOrArray.seek(l3);
            int n4 = this.readUnsignedShort(randomAccessFileOrArray);
            randomAccessFileOrArray.skip(12 * n4);
            l3 = this.readUnsignedInt(randomAccessFileOrArray);
        }
        randomAccessFileOrArray.seek(l3);
        this.initialize(randomAccessFileOrArray);
        randomAccessFileOrArray.seek(l2);
    }

    public TIFFDirectory(RandomAccessFileOrArray randomAccessFileOrArray, long l2, int n) throws IOException {
        long l3 = randomAccessFileOrArray.getFilePointer();
        randomAccessFileOrArray.seek(0L);
        int n2 = randomAccessFileOrArray.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        this.isBigEndian = n2 == 19789;
        randomAccessFileOrArray.seek(l2);
        for (int i2 = 0; i2 < n; ++i2) {
            int n3 = this.readUnsignedShort(randomAccessFileOrArray);
            randomAccessFileOrArray.seek(l2 + (long)(12 * n3));
            l2 = this.readUnsignedInt(randomAccessFileOrArray);
            randomAccessFileOrArray.seek(l2);
        }
        this.initialize(randomAccessFileOrArray);
        randomAccessFileOrArray.seek(l3);
    }

    private void initialize(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        long l2 = 0L;
        long l3 = randomAccessFileOrArray.length();
        this.IFDOffset = randomAccessFileOrArray.getFilePointer();
        this.numEntries = this.readUnsignedShort(randomAccessFileOrArray);
        this.fields = new TIFFField[this.numEntries];
        for (int i2 = 0; i2 < this.numEntries && l2 < l3; ++i2) {
            int n = this.readUnsignedShort(randomAccessFileOrArray);
            int n2 = this.readUnsignedShort(randomAccessFileOrArray);
            int n3 = (int)this.readUnsignedInt(randomAccessFileOrArray);
            boolean bl = true;
            l2 = randomAccessFileOrArray.getFilePointer() + 4;
            try {
                if (n3 * sizeOfType[n2] > 4) {
                    long l4 = this.readUnsignedInt(randomAccessFileOrArray);
                    if (l4 < l3) {
                        randomAccessFileOrArray.seek(l4);
                    } else {
                        bl = false;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                bl = false;
            }
            if (bl) {
                this.fieldIndex.put(new Integer(n), new Integer(i2));
                Object object = null;
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        Object[] objectArray;
                        Object object2;
                        byte[] byArray = new byte[n3];
                        randomAccessFileOrArray.readFully(byArray, 0, n3);
                        if (n2 == 2) {
                            int n4 = 0;
                            int n5 = 0;
                            object2 = new ArrayList();
                            while (n4 < n3) {
                                while (n4 < n3 && byArray[n4++] != 0) {
                                }
                                ((ArrayList)object2).add(new String(byArray, n5, n4 - n5));
                                n5 = n4;
                            }
                            n3 = ((ArrayList)object2).size();
                            objectArray = new String[n3];
                            for (int i3 = 0; i3 < n3; ++i3) {
                                objectArray[i3] = (short)((String)((ArrayList)object2).get(i3));
                            }
                            object = objectArray;
                            break;
                        }
                        object = byArray;
                        break;
                    }
                    case 3: {
                        int n6;
                        char[] cArray = new char[n3];
                        for (n6 = 0; n6 < n3; ++n6) {
                            cArray[n6] = (char)this.readUnsignedShort(randomAccessFileOrArray);
                        }
                        object = cArray;
                        break;
                    }
                    case 4: {
                        int n6;
                        long[] lArray = new long[n3];
                        for (n6 = 0; n6 < n3; ++n6) {
                            lArray[n6] = this.readUnsignedInt(randomAccessFileOrArray);
                        }
                        object = lArray;
                        break;
                    }
                    case 5: {
                        int n6;
                        Object object2 = new long[n3][2];
                        for (n6 = 0; n6 < n3; ++n6) {
                            object2[n6][0] = this.readUnsignedInt(randomAccessFileOrArray);
                            object2[n6][1] = this.readUnsignedInt(randomAccessFileOrArray);
                        }
                        object = object2;
                        break;
                    }
                    case 8: {
                        int n6;
                        Object[] objectArray = new short[n3];
                        for (n6 = 0; n6 < n3; ++n6) {
                            objectArray[n6] = this.readShort(randomAccessFileOrArray);
                        }
                        object = objectArray;
                        break;
                    }
                    case 9: {
                        int n6;
                        int[] nArray = new int[n3];
                        for (n6 = 0; n6 < n3; ++n6) {
                            nArray[n6] = this.readInt(randomAccessFileOrArray);
                        }
                        object = nArray;
                        break;
                    }
                    case 10: {
                        int n6;
                        int[][] nArray = new int[n3][2];
                        for (n6 = 0; n6 < n3; ++n6) {
                            nArray[n6][0] = this.readInt(randomAccessFileOrArray);
                            nArray[n6][1] = this.readInt(randomAccessFileOrArray);
                        }
                        object = nArray;
                        break;
                    }
                    case 11: {
                        int n6;
                        float[] fArray = new float[n3];
                        for (n6 = 0; n6 < n3; ++n6) {
                            fArray[n6] = this.readFloat(randomAccessFileOrArray);
                        }
                        object = fArray;
                        break;
                    }
                    case 12: {
                        int n6;
                        double[] dArray = new double[n3];
                        for (n6 = 0; n6 < n3; ++n6) {
                            dArray[n6] = this.readDouble(randomAccessFileOrArray);
                        }
                        object = dArray;
                        break;
                    }
                }
                this.fields[i2] = new TIFFField(n, n2, n3, object);
            }
            randomAccessFileOrArray.seek(l2);
        }
        try {
            this.nextIFDOffset = this.readUnsignedInt(randomAccessFileOrArray);
        }
        catch (Exception exception) {
            this.nextIFDOffset = 0L;
        }
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public TIFFField getField(int n) {
        Integer n2 = (Integer)this.fieldIndex.get(new Integer(n));
        if (n2 == null) {
            return null;
        }
        return this.fields[n2];
    }

    public boolean isTagPresent(int n) {
        return this.fieldIndex.containsKey(new Integer(n));
    }

    public int[] getTags() {
        int[] nArray = new int[this.fieldIndex.size()];
        Enumeration enumeration = this.fieldIndex.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n++] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    public TIFFField[] getFields() {
        return this.fields;
    }

    public byte getFieldAsByte(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        byte[] byArray = this.fields[n3].getAsBytes();
        return byArray[n2];
    }

    public byte getFieldAsByte(int n) {
        return this.getFieldAsByte(n, 0);
    }

    public long getFieldAsLong(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsLong(n2);
    }

    public long getFieldAsLong(int n) {
        return this.getFieldAsLong(n, 0);
    }

    public float getFieldAsFloat(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsFloat(n2);
    }

    public float getFieldAsFloat(int n) {
        return this.getFieldAsFloat(n, 0);
    }

    public double getFieldAsDouble(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsDouble(n2);
    }

    public double getFieldAsDouble(int n) {
        return this.getFieldAsDouble(n, 0);
    }

    private short readShort(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readShort();
        }
        return randomAccessFileOrArray.readShortLE();
    }

    private int readUnsignedShort(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readUnsignedShort();
        }
        return randomAccessFileOrArray.readUnsignedShortLE();
    }

    private int readInt(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readInt();
        }
        return randomAccessFileOrArray.readIntLE();
    }

    private long readUnsignedInt(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readUnsignedInt();
        }
        return randomAccessFileOrArray.readUnsignedIntLE();
    }

    private long readLong(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readLong();
        }
        return randomAccessFileOrArray.readLongLE();
    }

    private float readFloat(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readFloat();
        }
        return randomAccessFileOrArray.readFloatLE();
    }

    private double readDouble(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readDouble();
        }
        return randomAccessFileOrArray.readDoubleLE();
    }

    private static int readUnsignedShort(RandomAccessFileOrArray randomAccessFileOrArray, boolean bl) throws IOException {
        if (bl) {
            return randomAccessFileOrArray.readUnsignedShort();
        }
        return randomAccessFileOrArray.readUnsignedShortLE();
    }

    private static long readUnsignedInt(RandomAccessFileOrArray randomAccessFileOrArray, boolean bl) throws IOException {
        if (bl) {
            return randomAccessFileOrArray.readUnsignedInt();
        }
        return randomAccessFileOrArray.readUnsignedIntLE();
    }

    public static int getNumDirectories(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        long l2 = randomAccessFileOrArray.getFilePointer();
        randomAccessFileOrArray.seek(0L);
        int n = randomAccessFileOrArray.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        boolean bl = n == 19789;
        int n2 = TIFFDirectory.readUnsignedShort(randomAccessFileOrArray, bl);
        if (n2 != 42) {
            throw new IllegalArgumentException("Bad magic number, should be 42.");
        }
        randomAccessFileOrArray.seek(4L);
        long l3 = TIFFDirectory.readUnsignedInt(randomAccessFileOrArray, bl);
        int n3 = 0;
        while (l3 != 0L) {
            ++n3;
            try {
                randomAccessFileOrArray.seek(l3);
                int n4 = TIFFDirectory.readUnsignedShort(randomAccessFileOrArray, bl);
                randomAccessFileOrArray.skip(12 * n4);
                l3 = TIFFDirectory.readUnsignedInt(randomAccessFileOrArray, bl);
            }
            catch (EOFException eOFException) {
                // empty catch block
                break;
            }
        }
        randomAccessFileOrArray.seek(l2);
        return n3;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public long getIFDOffset() {
        return this.IFDOffset;
    }

    public long getNextIFDOffset() {
        return this.nextIFDOffset;
    }
}

