/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.ms.outlook.appointment;

import com.moyosoft.connector.com.ComUtil;
import com.moyosoft.connector.com.ComponentObjectModelException;
import com.moyosoft.connector.com.Dispatch;
import com.moyosoft.connector.com.MapiProp;
import com.moyosoft.connector.com.MapiPropertyValue;
import com.moyosoft.connector.com.Variant;
import com.moyosoft.connector.ms.outlook.Outlook;
import com.moyosoft.connector.ms.outlook.appointment.BusyStatus;
import com.moyosoft.connector.ms.outlook.appointment.NetMeetingType;
import com.moyosoft.connector.ms.outlook.appointment.ResponseStatus;
import com.moyosoft.connector.ms.outlook.attachment.AttachmentType;
import com.moyosoft.connector.ms.outlook.attachment.AttachmentsCollection;
import com.moyosoft.connector.ms.outlook.attachment.IAttachmentsContainer;
import com.moyosoft.connector.ms.outlook.attachment.OutlookAttachment;
import com.moyosoft.connector.ms.outlook.folder.FolderType;
import com.moyosoft.connector.ms.outlook.folder.OutlookFolder;
import com.moyosoft.connector.ms.outlook.item.ConflictsCollection;
import com.moyosoft.connector.ms.outlook.item.DownloadState;
import com.moyosoft.connector.ms.outlook.item.ImportanceType;
import com.moyosoft.connector.ms.outlook.item.ItemType;
import com.moyosoft.connector.ms.outlook.item.OutlookItem;
import com.moyosoft.connector.ms.outlook.item.OutlookItemType;
import com.moyosoft.connector.ms.outlook.item.SensitivityType;
import com.moyosoft.connector.ms.outlook.mail.OutlookMail;
import com.moyosoft.connector.ms.outlook.meeting.MeetingResponse;
import com.moyosoft.connector.ms.outlook.meeting.MeetingStatus;
import com.moyosoft.connector.ms.outlook.meeting.OutlookMeeting;
import com.moyosoft.connector.ms.outlook.properties.ItemPropertiesCollection;
import com.moyosoft.connector.ms.outlook.properties.UserPropertiesCollection;
import com.moyosoft.connector.ms.outlook.recipient.RecipientsCollection;
import com.moyosoft.connector.ms.outlook.recurrence.RecurrencePattern;
import com.moyosoft.connector.ms.outlook.recurrence.RecurrenceState;
import com.moyosoft.connector.ms.outlook.remote.RemoteStatus;
import com.moyosoft.connector.ms.outlook.ui.FormDescription;
import com.moyosoft.connector.ms.outlook.ui.Inspector;
import com.moyosoft.connector.ms.outlook.ui.InspectorClose;
import com.moyosoft.connector.ms.outlook.util.Mapi;
import java.io.File;
import java.util.Date;

public class OutlookAppointment
extends OutlookItem
implements IAttachmentsContainer {
    private static final byte[] e = new byte[]{0, 6, 32, 2, 0, 0, 0, 0, -64, 0, 0, 0, 0, 0, 0, 70};
    private static final byte[] f = new byte[]{110, -40, -38, -112, 69, 11, 16, 27, -104, -38, 0, -86, 0, 63, 19, 5};

    public OutlookAppointment(OutlookFolder outlookFolder) throws ComponentObjectModelException {
        this.mDispatch = outlookFolder.createItem(ItemType.APPOINTMENT).getDispatch();
    }

    public OutlookAppointment(Outlook outlook) throws ComponentObjectModelException {
        this.mDispatch = outlook.getDefaultFolder(FolderType.CALENDAR).createItem(ItemType.APPOINTMENT).getDispatch();
    }

    public OutlookAppointment(Dispatch dispatch) {
        super(dispatch);
    }

    public OutlookItemType getType() {
        return OutlookItemType.APPOINTMENT;
    }

    protected OutlookItem createInstance(Dispatch dispatch) {
        return new OutlookAppointment(dispatch);
    }

    public String getGlobalAppointmentId() throws ComponentObjectModelException {
        if (this.mDispatch.hasIdOfName("GlobalAppointmentID") > 0) {
            return this.mDispatch.invokeGetter("GlobalAppointmentID").getString();
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return null;
        }
        int n = mapiProp.getIdFromName(f, 3);
        MapiPropertyValue mapiPropertyValue = mapiProp.getProperty(n & 0xFFFF0000 | 0x102);
        if (mapiPropertyValue == null) {
            return null;
        }
        return mapiPropertyValue.getString();
    }

    public int getColorLabel() throws ComponentObjectModelException {
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return -1;
        }
        int n = mapiProp.getIdFromName(e, 33300);
        MapiPropertyValue mapiPropertyValue = mapiProp.getProperty(n);
        if (mapiPropertyValue == null) {
            return -1;
        }
        return mapiPropertyValue.getInt();
    }

    public void setColorLabel(int n) throws ComponentObjectModelException {
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        MapiPropertyValue mapiPropertyValue = Mapi.createPropertyValue(this.mDispatch.getComManager(), n);
        if (mapiPropertyValue == null) {
            return;
        }
        int n2 = mapiProp.getIdFromName(e, 33300);
        mapiProp.setProperty(n2, mapiPropertyValue);
    }

    public AttachmentsCollection getAttachments() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Attachments").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new AttachmentsCollection(dispatch);
    }

    public OutlookAttachment createAttachment(File file, AttachmentType attachmentType) {
        return this.getAttachments().add(file, attachmentType);
    }

    public int getAttachmentsCount() {
        return this.getAttachments().getCount();
    }

    public String getBillingInformation() {
        return this.mDispatch.invokeGetter("BillingInformation").getString();
    }

    public void setBillingInformation(String string) {
        this.mDispatch.invokeSetter("BillingInformation", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getBody() {
        return this.mDispatch.invokeGetter("Body").getString();
    }

    public void setBody(String string) {
        this.mDispatch.invokeSetter("Body", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCategories() {
        return this.mDispatch.invokeGetter("Categories").getString();
    }

    public void setCategories(String string) {
        this.mDispatch.invokeSetter("Categories", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCompanies() {
        return this.mDispatch.invokeGetter("Companies").getString();
    }

    public void setCompanies(String string) {
        this.mDispatch.invokeSetter("Companies", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getConversationIndex() {
        return this.mDispatch.invokeGetter("ConversationIndex").getString();
    }

    public String getConversationTopic() {
        return this.mDispatch.invokeGetter("ConversationTopic").getString();
    }

    public FormDescription getFormDescription() {
        Dispatch dispatch = this.mDispatch.invokeGetter("FormDescription").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new FormDescription(dispatch);
    }

    public Inspector getInspector() {
        Dispatch dispatch = this.mDispatch.invokeGetter("GetInspector").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new Inspector(dispatch);
    }

    public ImportanceType getImportance() {
        return ImportanceType.getById(this.mDispatch.invokeGetter("Importance").getAsInt());
    }

    public void setImportance(ImportanceType importanceType) {
        this.mDispatch.invokeSetter("Importance", ComUtil.createVariant(this.mDispatch, importanceType.getTypeValue()));
    }

    public String getMessageClass() {
        return this.mDispatch.invokeGetter("MessageClass").getString();
    }

    public void setMessageClass(String string) {
        this.mDispatch.invokeSetter("MessageClass", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getMileage() {
        return this.mDispatch.invokeGetter("Mileage").getString();
    }

    public void setMileage(String string) {
        this.mDispatch.invokeSetter("Mileage", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isNoAging() {
        return this.mDispatch.invokeGetter("NoAging").getBoolean();
    }

    public void setNoAging(boolean bl) {
        this.mDispatch.invokeSetter("NoAging", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isSaved() {
        return this.mDispatch.invokeGetter("Saved").getBoolean();
    }

    public SensitivityType getSensitivity() {
        return SensitivityType.getById(this.mDispatch.invokeGetter("Sensitivity").getAsInt());
    }

    public void setSensitivity(SensitivityType sensitivityType) {
        this.mDispatch.invokeSetter("Sensitivity", ComUtil.createVariant(this.mDispatch, sensitivityType.getTypeValue()));
    }

    public int getSize() {
        return this.mDispatch.invokeGetter("Size").getInt();
    }

    public String getSubject() {
        return this.mDispatch.invokeGetter("Subject").getString();
    }

    public void setSubject(String string) {
        this.mDispatch.invokeSetter("Subject", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isUnRead() {
        return this.mDispatch.invokeGetter("UnRead").getBoolean();
    }

    public void setUnRead(boolean bl) {
        this.mDispatch.invokeSetter("UnRead", ComUtil.createVariant(this.mDispatch, bl));
    }

    public UserPropertiesCollection getUserProperties() {
        Dispatch dispatch = this.mDispatch.invokeGetter("UserProperties").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new UserPropertiesCollection(dispatch);
    }

    public void close(InspectorClose inspectorClose) {
        this.mDispatch.invokeMethod("Close", new Variant[]{ComUtil.createVariant(this.mDispatch, inspectorClose.getTypeValue())});
    }

    public boolean isAllDayEvent() {
        return this.mDispatch.invokeGetter("AllDayEvent").getBoolean();
    }

    public void setAllDayEvent(boolean bl) {
        this.mDispatch.invokeSetter("AllDayEvent", ComUtil.createVariant(this.mDispatch, bl));
    }

    public BusyStatus getBusyStatus() {
        return BusyStatus.getById(this.mDispatch.invokeGetter("BusyStatus").getAsInt());
    }

    public void setBusyStatus(BusyStatus busyStatus) {
        this.mDispatch.invokeSetter("BusyStatus", ComUtil.createVariant(this.mDispatch, busyStatus.getTypeValue()));
    }

    public int getDuration() {
        return this.mDispatch.invokeGetter("Duration").getInt();
    }

    public void setDuration(int n) {
        this.mDispatch.invokeSetter("Duration", ComUtil.createVariant(this.mDispatch, n));
    }

    public Date getEnd() {
        return this.mDispatch.invokeGetter("End").getDate();
    }

    public void setEnd(Date date) {
        this.mDispatch.invokeSetter("End", ComUtil.createVariant(this.mDispatch, date));
    }

    public boolean isOnlineMeeting() {
        return this.mDispatch.invokeGetter("IsOnlineMeeting").getBoolean();
    }

    public void setIsOnlineMeeting(boolean bl) {
        this.mDispatch.invokeSetter("IsOnlineMeeting", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean getIsRecurring() {
        return this.isRecurring();
    }

    public boolean isRecurring() {
        return this.mDispatch.invokeGetter("IsRecurring").getBoolean();
    }

    public String getLocation() {
        return this.mDispatch.invokeGetter("Location").getString();
    }

    public void setLocation(String string) {
        this.mDispatch.invokeSetter("Location", ComUtil.createVariant(this.mDispatch, string));
    }

    public MeetingStatus getMeetingStatus() {
        return MeetingStatus.getById(this.mDispatch.invokeGetter("MeetingStatus").getAsInt());
    }

    public void setMeetingStatus(MeetingStatus meetingStatus) {
        this.mDispatch.invokeSetter("MeetingStatus", ComUtil.createVariant(this.mDispatch, meetingStatus.getTypeValue()));
    }

    public boolean isNetMeetingAutoStart() {
        return this.mDispatch.invokeGetter("NetMeetingAutoStart").getBoolean();
    }

    public void setNetMeetingAutoStart(boolean bl) {
        this.mDispatch.invokeSetter("NetMeetingAutoStart", ComUtil.createVariant(this.mDispatch, bl));
    }

    public String getNetMeetingOrganizerAlias() {
        return this.mDispatch.invokeGetter("NetMeetingOrganizerAlias").getString();
    }

    public void setNetMeetingOrganizerAlias(String string) {
        this.mDispatch.invokeSetter("NetMeetingOrganizerAlias", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getNetMeetingServer() {
        return this.mDispatch.invokeGetter("NetMeetingServer").getString();
    }

    public void setNetMeetingServer(String string) {
        this.mDispatch.invokeSetter("NetMeetingServer", ComUtil.createVariant(this.mDispatch, string));
    }

    public NetMeetingType getNetMeetingType() {
        return NetMeetingType.getById(this.mDispatch.invokeGetter("NetMeetingType").getAsInt());
    }

    public void setNetMeetingType(NetMeetingType netMeetingType) {
        this.mDispatch.invokeSetter("NetMeetingType", ComUtil.createVariant(this.mDispatch, netMeetingType.getTypeValue()));
    }

    public String getOptionalAttendees() {
        return this.mDispatch.invokeGetter("OptionalAttendees").getString();
    }

    public void setOptionalAttendees(String string) {
        this.mDispatch.invokeSetter("OptionalAttendees", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getOrganizer() {
        return this.mDispatch.invokeGetter("Organizer").getString();
    }

    public RecipientsCollection getRecipients() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Recipients").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new RecipientsCollection(OutlookItemType.APPOINTMENT, dispatch);
    }

    public RecurrenceState getRecurrenceState() {
        return RecurrenceState.getById(this.mDispatch.invokeGetter("RecurrenceState").getAsInt());
    }

    public int getReminderMinutesBeforeStart() {
        return this.mDispatch.invokeGetter("ReminderMinutesBeforeStart").getInt();
    }

    public void setReminderMinutesBeforeStart(int n) {
        this.mDispatch.invokeSetter("ReminderMinutesBeforeStart", ComUtil.createVariant(this.mDispatch, n));
    }

    public boolean isReminderOverrideDefault() {
        return this.mDispatch.invokeGetter("ReminderOverrideDefault").getBoolean();
    }

    public void setReminderOverrideDefault(boolean bl) {
        this.mDispatch.invokeSetter("ReminderOverrideDefault", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isReminderPlaySound() {
        return this.mDispatch.invokeGetter("ReminderPlaySound").getBoolean();
    }

    public void setReminderPlaySound(boolean bl) {
        this.mDispatch.invokeSetter("ReminderPlaySound", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isReminderSet() {
        return this.mDispatch.invokeGetter("ReminderSet").getBoolean();
    }

    public void setReminderSet(boolean bl) {
        this.mDispatch.invokeSetter("ReminderSet", ComUtil.createVariant(this.mDispatch, bl));
    }

    public String getReminderSoundFile() {
        return this.mDispatch.invokeGetter("ReminderSoundFile").getString();
    }

    public void setReminderSoundFile(String string) {
        this.mDispatch.invokeSetter("ReminderSoundFile", ComUtil.createVariant(this.mDispatch, string));
    }

    public Date getReplyTime() {
        return this.mDispatch.invokeGetter("ReplyTime").getDate();
    }

    public void setReplyTime(Date date) {
        this.mDispatch.invokeSetter("ReplyTime", ComUtil.createVariant(this.mDispatch, date));
    }

    public String getRequiredAttendees() {
        return this.mDispatch.invokeGetter("RequiredAttendees").getString();
    }

    public void setRequiredAttendees(String string) {
        this.mDispatch.invokeSetter("RequiredAttendees", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getResources() {
        return this.mDispatch.invokeGetter("Resources").getString();
    }

    public void setResources(String string) {
        this.mDispatch.invokeSetter("Resources", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isResponseRequested() {
        return this.mDispatch.invokeGetter("ResponseRequested").getBoolean();
    }

    public void setResponseRequested(boolean bl) {
        this.mDispatch.invokeSetter("ResponseRequested", ComUtil.createVariant(this.mDispatch, bl));
    }

    public ResponseStatus getResponseStatus() {
        return ResponseStatus.getById(this.mDispatch.invokeGetter("ResponseStatus").getAsInt());
    }

    public Date getStart() {
        return this.mDispatch.invokeGetter("Start").getDate();
    }

    public void setStart(Date date) {
        this.mDispatch.invokeSetter("Start", ComUtil.createVariant(this.mDispatch, date));
    }

    public void clearRecurrencePattern() {
        this.mDispatch.invokeMethod("ClearRecurrencePattern");
    }

    public OutlookMail forwardAsVcal() {
        Dispatch dispatch = this.mDispatch.invokeMethod("ForwardAsVcal").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMail(dispatch);
    }

    public RecurrencePattern getRecurrencePattern() {
        Variant variant = this.mDispatch.invokeMethod("GetRecurrencePattern");
        if (variant == null) {
            return null;
        }
        Dispatch dispatch = variant.getDispatch();
        if (dispatch == null) {
            return null;
        }
        variant.dispose();
        return new RecurrencePattern(dispatch);
    }

    public OutlookMeeting respond(MeetingResponse meetingResponse) {
        Dispatch dispatch = this.mDispatch.invokeMethod("Respond", new Variant[]{ComUtil.createVariant(this.mDispatch, meetingResponse.getTypeValue())}).getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMeeting(dispatch);
    }

    public OutlookMeeting respond(MeetingResponse meetingResponse, boolean bl) {
        Dispatch dispatch = this.mDispatch.invokeMethod("Respond", new Variant[]{ComUtil.createVariant(this.mDispatch, meetingResponse.getTypeValue()), ComUtil.createVariant(this.mDispatch, bl)}).getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMeeting(dispatch);
    }

    public OutlookMeeting respond(MeetingResponse meetingResponse, boolean bl, boolean bl2) {
        Dispatch dispatch = this.mDispatch.invokeMethod("Respond", new Variant[]{ComUtil.createVariant(this.mDispatch, meetingResponse.getTypeValue()), ComUtil.createVariant(this.mDispatch, bl), ComUtil.createVariant(this.mDispatch, bl2)}).getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMeeting(dispatch);
    }

    public void send() {
        this.mDispatch.invokeMethod("Send");
    }

    public String getNetMeetingDocPathName() {
        return this.mDispatch.invokeGetter("NetMeetingDocPathName").getString();
    }

    public void setNetMeetingDocPathName(String string) {
        this.mDispatch.invokeSetter("NetMeetingDocPathName", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getNetShowURL() {
        return this.mDispatch.invokeGetter("NetShowURL").getString();
    }

    public void setNetShowURL(String string) {
        this.mDispatch.invokeSetter("NetShowURL", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isConferenceServerAllowExternal() {
        return this.mDispatch.invokeGetter("ConferenceServerAllowExternal").getBoolean();
    }

    public void setConferenceServerAllowExternal(boolean bl) {
        this.mDispatch.invokeSetter("ConferenceServerAllowExternal", ComUtil.createVariant(this.mDispatch, bl));
    }

    public String getConferenceServerPassword() {
        return this.mDispatch.invokeGetter("ConferenceServerPassword").getString();
    }

    public void setConferenceServerPassword(String string) {
        this.mDispatch.invokeSetter("ConferenceServerPassword", ComUtil.createVariant(this.mDispatch, string));
    }

    public ItemPropertiesCollection getItemProperties() {
        Dispatch dispatch = this.mDispatch.invokeGetter("ItemProperties").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ItemPropertiesCollection(dispatch);
    }

    public DownloadState getDownloadState() {
        return DownloadState.getById(this.mDispatch.invokeGetter("DownloadState").getAsInt());
    }

    public void showCategoriesDialog() {
        this.mDispatch.invokeMethod("ShowCategoriesDialog");
    }

    public int getInternetCodepage() {
        return this.mDispatch.invokeGetter("InternetCodepage").getInt();
    }

    public void setInternetCodepage(int n) {
        this.mDispatch.invokeSetter("InternetCodepage", ComUtil.createVariant(this.mDispatch, n));
    }

    public RemoteStatus getMarkForDownload() {
        return RemoteStatus.getById(this.mDispatch.invokeGetter("MarkForDownload").getAsInt());
    }

    public void setMarkForDownload(RemoteStatus remoteStatus) {
        this.mDispatch.invokeSetter("MarkForDownload", ComUtil.createVariant(this.mDispatch, remoteStatus.getTypeValue()));
    }

    public boolean isConflict() {
        return this.mDispatch.invokeGetter("IsConflict").getBoolean();
    }

    public String getMeetingWorkspaceURL() {
        return this.mDispatch.invokeGetter("MeetingWorkspaceURL").getString();
    }

    public boolean isAutoResolvedWinner() {
        return this.mDispatch.invokeGetter("AutoResolvedWinner").getBoolean();
    }

    public ConflictsCollection getConflicts() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Conflicts").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ConflictsCollection(dispatch);
    }
}

