/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.ms.outlook.folder;

import com.moyosoft.connector.com.ComUtil;
import com.moyosoft.connector.com.ComponentObjectModelException;
import com.moyosoft.connector.com.Dispatch;
import com.moyosoft.connector.com.Variant;
import com.moyosoft.connector.ms.outlook.folder.FolderStoreType;
import com.moyosoft.connector.ms.outlook.folder.FolderType;
import com.moyosoft.connector.ms.outlook.folder.FoldersCollection;
import com.moyosoft.connector.ms.outlook.folder.OutlookFolderID;
import com.moyosoft.connector.ms.outlook.folder.ShowItemCount;
import com.moyosoft.connector.ms.outlook.folder.a;
import com.moyosoft.connector.ms.outlook.item.ItemType;
import com.moyosoft.connector.ms.outlook.item.ItemsCollection;
import com.moyosoft.connector.ms.outlook.item.OutlookItem;
import com.moyosoft.connector.ms.outlook.ui.Explorer;
import com.moyosoft.connector.ms.outlook.ui.FolderDisplayMode;
import com.moyosoft.connector.ms.outlook.ui.View;
import com.moyosoft.connector.ms.outlook.ui.ViewsCollection;
import com.moyosoft.connector.ms.outlook.util.ObjectClass;

public class OutlookFolder {
    private Dispatch a;

    public OutlookFolder(Dispatch dispatch) {
        this.a = dispatch;
    }

    public OutlookFolder(OutlookFolder outlookFolder, String string) {
        this.a = outlookFolder.getFolders().add(string).getDispatch();
    }

    public OutlookFolder(OutlookFolder outlookFolder, String string, FolderType folderType) {
        this.a = outlookFolder.getFolders().add(string, folderType).getDispatch();
    }

    public Dispatch getDispatch() {
        return this.a;
    }

    public ItemType getDefaultItemType() {
        return ItemType.getById(this.a.invokeGetter("DefaultItemType").getAsInt());
    }

    public String getDescription() {
        return this.a.invokeGetter("Description").getString();
    }

    public void setDescription(String string) {
        this.a.invokeSetter("Description", ComUtil.createVariant(this.a, string));
    }

    public OutlookFolderID getFolderId() {
        return new OutlookFolderID(this.a(), this.b());
    }

    private String a() {
        return this.a.invokeGetter("EntryID").getString();
    }

    private String b() {
        return this.a.invokeGetter("StoreID").getString();
    }

    public FoldersCollection getFolders() throws ComponentObjectModelException {
        a a2 = this.c();
        if (a2 != null) {
            return new FoldersCollection(a2);
        }
        return null;
    }

    private a c() {
        Dispatch dispatch = this.a.invokeGetter("Folders").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new a(dispatch);
    }

    public OutlookFolder getFolder(String string) {
        return this.getFolders().get(string);
    }

    public ItemsCollection getItems() throws ComponentObjectModelException {
        Dispatch dispatch = this.a.invokeGetter("Items").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ItemsCollection(this, dispatch);
    }

    public String getName() {
        return this.a.invokeGetter("Name").getString();
    }

    public void setName(String string) {
        this.a.invokeSetter("Name", ComUtil.createVariant(this.a, string));
    }

    public OutlookFolder getParentFolder() {
        Dispatch dispatch = this.a.invokeGetter("Parent").getDispatch();
        if (dispatch == null) {
            return null;
        }
        int n = dispatch.invokeGetter("Class").getInt();
        if (n == ObjectClass.FOLDER.getTypeValue()) {
            return new OutlookFolder(dispatch);
        }
        return null;
    }

    public FolderStoreType getStoreType() {
        String string = this.getFolderId().getStoreId();
        if (string == null || string.length() == 0) {
            return null;
        }
        return OutlookFolder.a(string);
    }

    public String getStorePath() {
        String string = this.getFolderId().getStoreId();
        if (string == null || string.length() == 0) {
            return null;
        }
        return OutlookFolder.b(string);
    }

    private static FolderStoreType a(String string) {
        int n = string.indexOf("0000", 9);
        if (n < 0) {
            return FolderStoreType.UNKNOWN;
        }
        int n2 = string.indexOf("00", n += 4);
        if (n2 < 0 || n >= n2) {
            return FolderStoreType.UNKNOWN;
        }
        String string2 = string.substring(n, n2);
        String string3 = (string2 = OutlookFolder.a(string2, 2)).toLowerCase().trim();
        if ("mspst.dll".equals(string3) || "pstprx.dll".equals(string3)) {
            int n3 = string.length() - 1;
            while (string.charAt(n3) == '0') {
                if (--n3 >= 0) continue;
                return FolderStoreType.UNKNOWN;
            }
            return FolderStoreType.PST_FILE;
        }
        if ("msncon.dll".equals(string3)) {
            int n4 = string.length() - 1;
            while (string.charAt(n4) == '0') {
                if (--n4 >= 0) continue;
                return FolderStoreType.UNKNOWN;
            }
            return FolderStoreType.PST_FILE;
        }
        if ("emsmdb.dll".equals(string3)) {
            return FolderStoreType.EXCHANGE;
        }
        return FolderStoreType.UNKNOWN;
    }

    private static String b(String string) {
        int n = string.indexOf("0000", 9);
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf("00", n += 4);
        if (n2 < 0 || n >= n2) {
            return null;
        }
        String string2 = null;
        String string3 = string.substring(n, n2);
        String string4 = (string3 = OutlookFolder.a(string3, 2)).toLowerCase().trim();
        if ("mspst.dll".equals(string4) || "pstprx.dll".equals(string4)) {
            int n3 = string.length() - 1;
            while (string.charAt(n3) == '0') {
                if (--n3 >= 0) continue;
                return null;
            }
            string = string.substring(0, n3 + 1);
            n = string.lastIndexOf("000000") + 6;
            string2 = string.substring(n);
            string2 = OutlookFolder.a(string2, 2);
            return string2;
        }
        if ("msncon.dll".equals(string4)) {
            int n4 = string.length() - 1;
            while (string.charAt(n4) == '0') {
                if (--n4 >= 0) continue;
                return null;
            }
            string = string.substring(0, n4 + 1);
            n = string.lastIndexOf("00") + 2;
            string2 = string.substring(n);
            string2 = OutlookFolder.a(string2, 2);
            return string2;
        }
        if ("emsmdb.dll".equals(string4)) {
            return null;
        }
        return null;
    }

    private static String a(String string, int n) {
        String string2 = "";
        int n2 = 0;
        while (n2 < string.length()) {
            String string3 = string.substring(n2, n2 + n);
            int n3 = Integer.parseInt(string3, 16);
            if (n3 > 0) {
                char c2 = (char)n3;
                string2 = string2 + c2;
            }
            n2 += n;
        }
        return string2;
    }

    public int getUnReadItemCount() {
        return this.a.invokeGetter("UnReadItemCount").getInt();
    }

    public OutlookFolder copyTo(OutlookFolder outlookFolder) {
        Dispatch dispatch = this.a.invokeMethod("CopyTo", new Variant[]{ComUtil.createVariant(this.a, outlookFolder.getDispatch())}).getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookFolder(dispatch);
    }

    public void delete() {
        this.a.invokeMethod("Delete");
    }

    public void display() {
        this.a.invokeMethod("Display");
    }

    public Explorer getExplorer() {
        Dispatch dispatch = this.a.invokeMethod("GetExplorer").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new Explorer(dispatch);
    }

    public Explorer getExplorer(FolderDisplayMode folderDisplayMode) {
        Dispatch dispatch = this.a.invokeMethod("GetExplorer", new Variant[]{ComUtil.createVariant(this.a, folderDisplayMode.getTypeValue())}).getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new Explorer(dispatch);
    }

    public void moveTo(OutlookFolder outlookFolder) {
        this.a.invokeMethod("MoveTo", new Variant[]{ComUtil.createVariant(this.a, outlookFolder.getDispatch())});
    }

    public boolean isWebViewOn() {
        return this.a.invokeGetter("WebViewOn").getBoolean();
    }

    public void setWebViewOn(boolean bl) {
        this.a.invokeSetter("WebViewOn", ComUtil.createVariant(this.a, bl));
    }

    public String getWebViewURL() {
        return this.a.invokeGetter("WebViewURL").getString();
    }

    public void setWebViewURL(String string) {
        this.a.invokeSetter("WebViewURL", ComUtil.createVariant(this.a, string));
    }

    public boolean isWebViewAllowNavigation() {
        return this.a.invokeGetter("WebViewAllowNavigation").getBoolean();
    }

    public void setWebViewAllowNavigation(boolean bl) {
        this.a.invokeSetter("WebViewAllowNavigation", ComUtil.createVariant(this.a, bl));
    }

    public void addToPFFavorites() {
        this.a.invokeMethod("AddToPFFavorites");
    }

    public String getAddressBookName() {
        return this.a.invokeGetter("AddressBookName").getString();
    }

    public void setAddressBookName(String string) {
        this.a.invokeSetter("AddressBookName", ComUtil.createVariant(this.a, string));
    }

    public boolean isShowAsOutlookAB() {
        return this.a.invokeGetter("ShowAsOutlookAB").getBoolean();
    }

    public void setShowAsOutlookAB(boolean bl) {
        this.a.invokeSetter("ShowAsOutlookAB", ComUtil.createVariant(this.a, bl));
    }

    public String getFolderPath() {
        return this.a.invokeGetter("FolderPath").getString();
    }

    public void addToFavorites() {
        this.a.invokeMethod("AddToFavorites");
    }

    public void addToFavorites(boolean bl) {
        this.a.invokeMethod("AddToFavorites", new Variant[]{ComUtil.createVariant(this.a, bl)});
    }

    public void addToFavorites(boolean bl, String string) {
        this.a.invokeMethod("AddToFavorites", new Variant[]{ComUtil.createVariant(this.a, bl), ComUtil.createVariant(this.a, string)});
    }

    public boolean isInAppFolderSyncObject() {
        return this.a.invokeGetter("InAppFolderSyncObject").getBoolean();
    }

    public void setInAppFolderSyncObject(boolean bl) {
        this.a.invokeSetter("InAppFolderSyncObject", ComUtil.createVariant(this.a, bl));
    }

    public View getCurrentView() {
        Dispatch dispatch = this.a.invokeGetter("CurrentView").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new View(dispatch);
    }

    public boolean isCustomViewsOnly() {
        return this.a.invokeGetter("CustomViewsOnly").getBoolean();
    }

    public void setCustomViewsOnly(boolean bl) {
        this.a.invokeSetter("CustomViewsOnly", ComUtil.createVariant(this.a, bl));
    }

    public ViewsCollection getViews() {
        Dispatch dispatch = this.a.invokeGetter("Views").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ViewsCollection(dispatch);
    }

    public String getFullFolderPath() {
        return this.a.invokeGetter("FullFolderPath").getString();
    }

    public boolean isSharePointFolder() {
        return this.a.invokeGetter("IsSharePointFolder").getBoolean();
    }

    public ShowItemCount getShowItemCount() {
        return ShowItemCount.getById(this.a.invokeGetter("ShowItemCount").getAsInt());
    }

    public void setShowItemCount(ShowItemCount showItemCount) {
        this.a.invokeSetter("ShowItemCount", ComUtil.createVariant(this.a, showItemCount.getTypeValue()));
    }

    public OutlookFolder createFolder(String string, FolderType folderType) throws ComponentObjectModelException {
        return this.getFolders().add(string, folderType);
    }

    public OutlookItem createItem() throws ComponentObjectModelException {
        return this.getItems().createNew();
    }

    public OutlookItem createItem(ItemType itemType) throws ComponentObjectModelException {
        return this.getItems().createNew(itemType);
    }

    public int getFoldersCount() {
        a a2 = this.c();
        if (a2 != null) {
            int n = a2.a();
            a2.d();
            return n;
        }
        return 0;
    }

    public boolean hasChildren() {
        return this.getFoldersCount() > 0;
    }

    public void dispose() {
        if (this.a != null) {
            this.a.dispose();
        }
    }
}

