/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.registry;

import com.moyosoft.connector.registry.RegistryException;
import com.moyosoft.connector.registry.RegistryKey;
import com.moyosoft.connector.registry.RegistryValue;

public final class Registry {
    protected static final long HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    protected static final long HKEY_CURRENT_USER = -2147483647L;
    protected static final long HKEY_LOCAL_MACHINE = -2147483646L;
    protected static final long HKEY_USERS = -2147483645L;
    protected static final long HKEY_PERFORMANCE_DATA = -2147483644L;
    protected static final long HKEY_PERFORMANCE_TEXT = -2147483568L;
    protected static final long HKEY_PERFORMANCE_NLSTEXT = -2147483552L;
    protected static final long HKEY_CURRENT_CONFIG = -2147483643L;
    protected static final long HKEY_DYN_DATA = -2147483642L;

    private Registry() {
    }

    public static final RegistryKey getCurrentUserKey() throws RegistryException {
        return Registry.getStandardKey(-2147483647L);
    }

    public static final RegistryKey openCurrentUserKey(String string) throws RegistryException {
        return Registry.getCurrentUserKey().openKey(string);
    }

    public static final RegistryKey getUsersKey() throws RegistryException {
        return Registry.getStandardKey(-2147483645L);
    }

    public static final RegistryKey openUsersKey(String string) throws RegistryException {
        return Registry.getUsersKey().openKey(string);
    }

    public static final RegistryKey getCurrentConfigKey() throws RegistryException {
        return Registry.getStandardKey(-2147483643L);
    }

    public static final RegistryKey openCurrentConfigKey(String string) throws RegistryException {
        return Registry.getCurrentConfigKey().openKey(string);
    }

    public static final RegistryKey getLocalMachineKey() throws RegistryException {
        return Registry.getStandardKey(-2147483646L);
    }

    public static final RegistryKey openLocalMachineKey(String string) throws RegistryException {
        return Registry.getLocalMachineKey().openKey(string);
    }

    protected static final RegistryKey getStandardKey(long l2) {
        return new RegistryKey(l2);
    }

    protected static final native long openCurrentUserImpl() throws RegistryException;

    protected static final native long openKeyExImpl(long var0, String var2) throws RegistryException;

    protected static final native void loadKeyImpl(long var0, String var2, String var3) throws RegistryException;

    protected static final native void unloadKeyImpl(long var0, String var2) throws RegistryException;

    protected static final native long createKeyImpl(long var0, String var2) throws RegistryException;

    protected static final native void deleteKeyImpl(long var0, String var2) throws RegistryException;

    protected static final native void deleteValueImpl(long var0, String var2) throws RegistryException;

    protected static final native String enumKeyExImpl(long var0, int var2) throws RegistryException;

    protected static final native String enumValueImpl(long var0, int var2) throws RegistryException;

    protected static final native int querySubKeyCountImpl(long var0) throws RegistryException;

    protected static final native int queryValueCountImpl(long var0) throws RegistryException;

    protected static final native RegistryValue queryValueExImpl(long var0, String var2) throws RegistryException;

    protected static final native void setValueExImpl(long var0, String var2, int var3, byte[] var4) throws RegistryException;

    protected static final native void flushKeyImpl(long var0) throws RegistryException;

    protected static final native void closeKeyImpl(long var0) throws RegistryException;
}

