/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.registry;

import java.io.UnsupportedEncodingException;

public class RegistryValue {
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static final int REG_QWORD = 11;
    private int a;
    private byte[] b;

    public RegistryValue(int n, byte[] byArray) {
        this.a = n;
        this.b = byArray;
    }

    public RegistryValue(String string) {
        this.a = 1;
        this.b = RegistryValue.a(string);
    }

    public RegistryValue(String string, boolean bl) {
        this.a = bl ? 2 : 1;
        this.b = RegistryValue.a(string);
    }

    public RegistryValue(byte[] byArray) {
        this.a = 3;
        this.b = byArray;
    }

    public RegistryValue(int n) {
        this.a = 4;
        this.b = new byte[4];
        this.b[0] = (byte)(n >> 0 & 0xFF);
        this.b[1] = (byte)(n >> 8 & 0xFF);
        this.b[2] = (byte)(n >> 16 & 0xFF);
        this.b[3] = (byte)(n >> 24 & 0xFF);
    }

    public RegistryValue(long l2) {
        this.a = 11;
        this.b = new byte[8];
        this.b[0] = (byte)(l2 >> 0 & 0xFFL);
        this.b[1] = (byte)(l2 >> 8 & 0xFFL);
        this.b[2] = (byte)(l2 >> 16 & 0xFFL);
        this.b[3] = (byte)(l2 >> 24 & 0xFFL);
        this.b[4] = (byte)(l2 >> 32 & 0xFFL);
        this.b[5] = (byte)(l2 >> 40 & 0xFFL);
        this.b[6] = (byte)(l2 >> 48 & 0xFFL);
        this.b[7] = (byte)(l2 >> 56 & 0xFFL);
    }

    public int getType() {
        return this.a;
    }

    public byte[] getRawData() {
        return this.b;
    }

    public boolean isString() {
        return this.a == 1 || this.a == 2;
    }

    public boolean isBinary() {
        return this.a == 3;
    }

    public boolean isInteger() {
        return this.a == 4 || this.a == 5;
    }

    public boolean isLong() {
        return this.a == 11;
    }

    public boolean isSymbolicLink() {
        return this.a == 6;
    }

    public String getString() {
        if (this.isString() || this.isSymbolicLink()) {
            return RegistryValue.b(this.b);
        }
        return null;
    }

    public byte[] getBinaryData() {
        if (this.isBinary()) {
            return this.b;
        }
        return null;
    }

    public int getInteger() {
        if (this.isInteger()) {
            if (this.b == null || this.b.length != 4) {
                return 0;
            }
            if (this.a == 4) {
                return (this.b[0] & 0xFF) << 0 | (this.b[1] & 0xFF) << 8 | (this.b[2] & 0xFF) << 16 | (this.b[3] & 0xFF) << 24;
            }
            if (this.a == 5) {
                return (this.b[3] & 0xFF) << 0 | (this.b[2] & 0xFF) << 8 | (this.b[1] & 0xFF) << 16 | (this.b[0] & 0xFF) << 24;
            }
        }
        return 0;
    }

    public long getLong() {
        if (this.isLong()) {
            if (this.b == null || this.b.length != 8) {
                return 0L;
            }
            if (this.a == 11) {
                return ((long)this.b[0] & 0xFFL) << 0 | ((long)this.b[1] & 0xFFL) << 8 | ((long)this.b[2] & 0xFFL) << 16 | ((long)this.b[3] & 0xFFL) << 24 | ((long)this.b[4] & 0xFFL) << 32 | ((long)this.b[5] & 0xFFL) << 40 | ((long)this.b[6] & 0xFFL) << 48 | ((long)this.b[7] & 0xFFL) << 56;
            }
        }
        return 0L;
    }

    public String getAsString() {
        if (this.isString() || this.isSymbolicLink()) {
            return this.getString();
        }
        if (this.isBinary()) {
            return RegistryValue.a(this.b);
        }
        if (this.isInteger()) {
            return Integer.toString(this.getInteger());
        }
        if (this.isLong()) {
            return Long.toString(this.getLong());
        }
        return RegistryValue.a(this.b);
    }

    public String toString() {
        String string = this.getAsString();
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String a(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] >= 0 && byArray[n] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF).toUpperCase());
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    private static byte[] a(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes("UTF-16LE");
            byte[] byArray2 = new byte[byArray.length + 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray2.length - 2] = 0;
            byArray2[byArray2.length - 1] = 0;
            return byArray2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static String b(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            if (byArray.length >= 2 && byArray[byArray.length - 1] == 0 && byArray[byArray.length - 2] == 0) {
                return new String(byArray, 0, byArray.length - 2, "UTF-16LE");
            }
            return new String(byArray, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

