/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.packaging.mime.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BASE64EncoderStream
extends FilterOutputStream {
    private byte[] buffer = new byte[3];
    private int bufsize = 0;
    private int count = 0;
    private int bytesPerLine;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public BASE64EncoderStream(OutputStream out, int bytesPerLine) {
        super(out);
        this.bytesPerLine = bytesPerLine;
    }

    public BASE64EncoderStream(OutputStream out) {
        this(out, 76);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        for (int i2 = 0; i2 < len; ++i2) {
            this.write(b2[off + i2]);
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(int c2) throws IOException {
        this.buffer[this.bufsize++] = (byte)c2;
        if (this.bufsize == 3) {
            this.encode();
            this.bufsize = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.bufsize > 0) {
            this.encode();
            this.bufsize = 0;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void encode() throws IOException {
        if (this.count + 4 > this.bytesPerLine) {
            this.out.write(13);
            this.out.write(10);
            this.count = 0;
        }
        if (this.bufsize == 1) {
            byte a2 = this.buffer[0];
            int b2 = 0;
            boolean c2 = false;
            this.out.write(pem_array[a2 >>> 2 & 0x3F]);
            this.out.write(pem_array[(a2 << 4 & 0x30) + (b2 >>> 4 & 0xF)]);
            this.out.write(61);
            this.out.write(61);
        } else if (this.bufsize == 2) {
            byte a3 = this.buffer[0];
            byte b3 = this.buffer[1];
            int c3 = 0;
            this.out.write(pem_array[a3 >>> 2 & 0x3F]);
            this.out.write(pem_array[(a3 << 4 & 0x30) + (b3 >>> 4 & 0xF)]);
            this.out.write(pem_array[(b3 << 2 & 0x3C) + (c3 >>> 6 & 3)]);
            this.out.write(61);
        } else {
            byte a4 = this.buffer[0];
            byte b4 = this.buffer[1];
            byte c4 = this.buffer[2];
            this.out.write(pem_array[a4 >>> 2 & 0x3F]);
            this.out.write(pem_array[(a4 << 4 & 0x30) + (b4 >>> 4 & 0xF)]);
            this.out.write(pem_array[(b4 << 2 & 0x3C) + (c4 >>> 6 & 3)]);
            this.out.write(pem_array[c4 & 0x3F]);
        }
        this.count += 4;
    }

    public static byte[] encode(byte[] inbuf) {
        if (inbuf.length == 0) {
            return inbuf;
        }
        byte[] outbuf = new byte[(inbuf.length + 2) / 3 * 4];
        int inpos = 0;
        int outpos = 0;
        for (int size = inbuf.length; size > 0; size -= 3) {
            byte c2;
            byte b2;
            byte a2;
            if (size == 1) {
                a2 = inbuf[inpos++];
                b2 = 0;
                c2 = 0;
                outbuf[outpos++] = (byte)pem_array[a2 >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)pem_array[(a2 << 4 & 0x30) + (b2 >>> 4 & 0xF)];
                outbuf[outpos++] = 61;
                outbuf[outpos++] = 61;
                continue;
            }
            if (size == 2) {
                a2 = inbuf[inpos++];
                b2 = inbuf[inpos++];
                c2 = 0;
                outbuf[outpos++] = (byte)pem_array[a2 >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)pem_array[(a2 << 4 & 0x30) + (b2 >>> 4 & 0xF)];
                outbuf[outpos++] = (byte)pem_array[(b2 << 2 & 0x3C) + (c2 >>> 6 & 3)];
                outbuf[outpos++] = 61;
                continue;
            }
            a2 = inbuf[inpos++];
            b2 = inbuf[inpos++];
            c2 = inbuf[inpos++];
            outbuf[outpos++] = (byte)pem_array[a2 >>> 2 & 0x3F];
            outbuf[outpos++] = (byte)pem_array[(a2 << 4 & 0x30) + (b2 >>> 4 & 0xF)];
            outbuf[outpos++] = (byte)pem_array[(b2 << 2 & 0x3C) + (c2 >>> 6 & 3)];
            outbuf[outpos++] = (byte)pem_array[c2 & 0x3F];
        }
        return outbuf;
    }
}

