/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.buffer.stax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jvnet.staxex.NamespaceContextEx;

public final class NamespaceContexHelper
implements NamespaceContextEx {
    private static int DEFAULT_SIZE = 8;
    private String[] prefixes = new String[DEFAULT_SIZE];
    private String[] namespaceURIs = new String[DEFAULT_SIZE];
    private int namespacePosition;
    private int[] contexts = new int[DEFAULT_SIZE];
    private int contextPosition;

    public NamespaceContexHelper() {
        this.prefixes[0] = "xml";
        this.namespaceURIs[0] = "http://www.w3.org/XML/1998/namespace";
        this.prefixes[1] = "xmlns";
        this.namespaceURIs[1] = "http://www.w3.org/2000/xmlns/";
        this.namespacePosition = 2;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        prefix = prefix.intern();
        for (int i2 = this.namespacePosition - 1; i2 >= 0; --i2) {
            String declaredPrefix = this.prefixes[i2];
            if (declaredPrefix != prefix) continue;
            return this.namespaceURIs[i2];
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        for (int i2 = this.namespacePosition - 1; i2 >= 0; --i2) {
            String declaredNamespaceURI = this.namespaceURIs[i2];
            if (declaredNamespaceURI != namespaceURI && !declaredNamespaceURI.equals(namespaceURI)) continue;
            String declaredPrefix = this.prefixes[i2];
            ++i2;
            while (i2 < this.namespacePosition) {
                if (declaredPrefix == this.prefixes[i2]) {
                    return null;
                }
                ++i2;
            }
            return declaredPrefix;
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> l2 = new ArrayList<String>();
        block0: for (int i2 = this.namespacePosition - 1; i2 >= 0; --i2) {
            String declaredNamespaceURI = this.namespaceURIs[i2];
            if (declaredNamespaceURI != namespaceURI && !declaredNamespaceURI.equals(namespaceURI)) continue;
            String declaredPrefix = this.prefixes[i2];
            for (int j2 = i2 + 1; j2 < this.namespacePosition; ++j2) {
                if (declaredPrefix == this.prefixes[j2]) continue block0;
            }
            l2.add(declaredPrefix);
        }
        return l2.iterator();
    }

    @Override
    public Iterator<NamespaceContextEx.Binding> iterator() {
        if (this.namespacePosition == 2) {
            return Collections.emptyList().iterator();
        }
        ArrayList<NamespaceBindingImpl> namespaces = new ArrayList<NamespaceBindingImpl>(this.namespacePosition);
        for (int i2 = this.namespacePosition - 1; i2 >= 2; --i2) {
            String declaredPrefix = this.prefixes[i2];
            for (int j2 = i2 + 1; j2 < this.namespacePosition && declaredPrefix != this.prefixes[j2]; ++j2) {
                namespaces.add(new NamespaceBindingImpl(i2));
            }
        }
        return namespaces.iterator();
    }

    public void declareDefaultNamespace(String namespaceURI) {
        this.declareNamespace("", namespaceURI);
    }

    public void declareNamespace(String prefix, String namespaceURI) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if ((prefix = prefix.intern()) == "xml" || prefix == "xmlns") {
            return;
        }
        if (namespaceURI != null) {
            namespaceURI = namespaceURI.intern();
        }
        if (this.namespacePosition == this.namespaceURIs.length) {
            this.resizeNamespaces();
        }
        this.prefixes[this.namespacePosition] = prefix;
        this.namespaceURIs[this.namespacePosition++] = namespaceURI;
    }

    private void resizeNamespaces() {
        int newLength = this.namespaceURIs.length * 3 / 2 + 1;
        String[] newPrefixes = new String[newLength];
        System.arraycopy(this.prefixes, 0, newPrefixes, 0, this.prefixes.length);
        this.prefixes = newPrefixes;
        String[] newNamespaceURIs = new String[newLength];
        System.arraycopy(this.namespaceURIs, 0, newNamespaceURIs, 0, this.namespaceURIs.length);
        this.namespaceURIs = newNamespaceURIs;
    }

    public void pushContext() {
        if (this.contextPosition == this.contexts.length) {
            this.resizeContexts();
        }
        this.contexts[this.contextPosition++] = this.namespacePosition;
    }

    private void resizeContexts() {
        int[] newContexts = new int[this.contexts.length * 3 / 2 + 1];
        System.arraycopy(this.contexts, 0, newContexts, 0, this.contexts.length);
        this.contexts = newContexts;
    }

    public void popContext() {
        if (this.contextPosition > 0) {
            this.namespacePosition = this.contexts[--this.contextPosition];
        }
    }

    public void resetContexts() {
        this.namespacePosition = 2;
    }

    private final class NamespaceBindingImpl
    implements NamespaceContextEx.Binding {
        int index;

        NamespaceBindingImpl(int index) {
            this.index = index;
        }

        @Override
        public String getPrefix() {
            return NamespaceContexHelper.this.prefixes[this.index];
        }

        @Override
        public String getNamespaceURI() {
            return NamespaceContexHelper.this.namespaceURIs[this.index];
        }
    }
}

