/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.message;

import com.oracle.webservices.api.EnvelopeStyle;
import com.oracle.webservices.api.EnvelopeStyleFeature;
import com.oracle.webservices.api.message.MessageContext;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Codecs;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import jakarta.xml.soap.MimeHeader;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.MTOMFeature;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;

public class MessageContextFactory
extends com.oracle.webservices.api.message.MessageContextFactory {
    private WSFeatureList features;
    private Codec soapCodec;
    private Codec xmlCodec;
    private EnvelopeStyleFeature envelopeStyle;
    private EnvelopeStyle.Style singleSoapStyle;

    public MessageContextFactory(WebServiceFeature[] wsf) {
        this(new WebServiceFeatureList(wsf));
    }

    public MessageContextFactory(WSFeatureList wsf) {
        this.features = wsf;
        this.envelopeStyle = this.features.get(EnvelopeStyleFeature.class);
        if (this.envelopeStyle == null) {
            this.envelopeStyle = new EnvelopeStyleFeature(EnvelopeStyle.Style.SOAP11);
            this.features.mergeFeatures(new WebServiceFeature[]{this.envelopeStyle}, false);
        }
        for (EnvelopeStyle.Style s : this.envelopeStyle.getStyles()) {
            if (s.isXML()) {
                if (this.xmlCodec != null) continue;
                this.xmlCodec = Codecs.createXMLCodec(this.features);
                continue;
            }
            if (this.soapCodec == null) {
                this.soapCodec = Codecs.createSOAPBindingCodec(this.features);
            }
            this.singleSoapStyle = s;
        }
    }

    @Override
    protected com.oracle.webservices.api.message.MessageContextFactory newFactory(WebServiceFeature ... f2) {
        return new MessageContextFactory(f2);
    }

    @Override
    public MessageContext createContext() {
        return this.packet(null);
    }

    @Override
    public MessageContext createContext(SOAPMessage soap) {
        this.throwIfIllegalMessageArgument(soap);
        if (this.saajFactory != null) {
            return this.packet(this.saajFactory.createMessage(soap));
        }
        return this.packet(Messages.create(soap));
    }

    @Override
    public MessageContext createContext(Source m2, EnvelopeStyle.Style envelopeStyle) {
        this.throwIfIllegalMessageArgument(m2);
        return this.packet(Messages.create(m2, SOAPVersion.from(envelopeStyle)));
    }

    @Override
    public MessageContext createContext(Source m2) {
        this.throwIfIllegalMessageArgument(m2);
        return this.packet(Messages.create(m2, SOAPVersion.from(this.singleSoapStyle)));
    }

    @Override
    public MessageContext createContext(InputStream in, String contentType) throws IOException {
        this.throwIfIllegalMessageArgument(in);
        Packet p = this.packet(null);
        this.soapCodec.decode(in, contentType, p);
        return p;
    }

    static String getHeader(MimeHeaders headers, String name) {
        String[] values = headers.getHeader(name);
        return values != null && values.length > 0 ? values[0] : null;
    }

    static Map<String, List<String>> toMap(MimeHeaders headers) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Iterator<MimeHeader> i2 = headers.getAllHeaders();
        while (i2.hasNext()) {
            MimeHeader mh = i2.next();
            List values = map.computeIfAbsent(mh.getName(), k2 -> new ArrayList());
            values.add(mh.getValue());
        }
        return map;
    }

    public MessageContext createContext(Message m2) {
        this.throwIfIllegalMessageArgument(m2);
        return this.packet(m2);
    }

    private Packet packet(Message m2) {
        MTOMFeature mf;
        Packet p = new Packet();
        p.codec = this.soapCodec;
        if (m2 != null) {
            p.setMessage(m2);
        }
        if ((mf = this.features.get(MTOMFeature.class)) != null) {
            p.setMtomFeature(mf);
        }
        p.setSAAJFactory(this.saajFactory);
        return p;
    }

    private void throwIfIllegalMessageArgument(Object message) throws IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("null messages are not allowed.  Consider using MessageContextFactory.createContext()");
        }
    }
}

