/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.message.stream;

import com.sun.istack.FinalArrayList;
import com.sun.istack.NotNull;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.ws.message.AbstractHeaderImpl;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.WebServiceException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class OutboundStreamHeader
extends AbstractHeaderImpl {
    private final XMLStreamBuffer infoset;
    private final String nsUri;
    private final String localName;
    private FinalArrayList<Attribute> attributes;
    private static final String TRUE_VALUE = "1";
    private static final String IS_REFERENCE_PARAMETER = "IsReferenceParameter";

    public OutboundStreamHeader(XMLStreamBuffer infoset, String nsUri, String localName) {
        this.infoset = infoset;
        this.nsUri = nsUri;
        this.localName = localName;
    }

    @Override
    @NotNull
    public String getNamespaceURI() {
        return this.nsUri;
    }

    @Override
    @NotNull
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public String getAttribute(String nsUri, String localName) {
        if (this.attributes == null) {
            this.parseAttributes();
        }
        for (int i2 = this.attributes.size() - 1; i2 >= 0; --i2) {
            Attribute a2 = (Attribute)this.attributes.get(i2);
            if (!a2.localName.equals(localName) || !a2.nsUri.equals(nsUri)) continue;
            return a2.value;
        }
        return null;
    }

    private void parseAttributes() {
        try {
            XMLStreamReader reader = this.readHeader();
            this.attributes = new FinalArrayList();
            for (int i2 = 0; i2 < reader.getAttributeCount(); ++i2) {
                String localName = reader.getAttributeLocalName(i2);
                String namespaceURI = reader.getAttributeNamespace(i2);
                String value = reader.getAttributeValue(i2);
                this.attributes.add(new Attribute(namespaceURI, localName, value));
            }
        }
        catch (XMLStreamException e2) {
            throw new WebServiceException("Unable to read the attributes for {" + this.nsUri + "}" + this.localName + " header", e2);
        }
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        return this.infoset.readAsXMLStreamReader();
    }

    @Override
    public void writeTo(XMLStreamWriter w) throws XMLStreamException {
        this.infoset.writeToXMLStreamWriter(w, true);
    }

    @Override
    public void writeTo(SOAPMessage saaj) throws SOAPException {
        try {
            SOAPHeader header = saaj.getSOAPHeader();
            if (header == null) {
                header = saaj.getSOAPPart().getEnvelope().addHeader();
            }
            this.infoset.writeTo(header);
        }
        catch (XMLStreamBufferException e2) {
            throw new SOAPException(e2);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        this.infoset.writeTo(contentHandler, errorHandler);
    }

    static final class Attribute {
        final String nsUri;
        final String localName;
        final String value;

        public Attribute(String nsUri, String localName, String value) {
            this.nsUri = Attribute.fixNull(nsUri);
            this.localName = localName;
            this.value = value;
        }

        private static String fixNull(String s) {
            if (s == null) {
                return "";
            }
            return s;
        }
    }
}

