/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Arrays;

public final class MethodUtil
extends SecureClassLoader {
    private static final String WS_UTIL_POLICY_PKG = "com.sun.xml.ws.policy.util.";
    private static final String TRAMPOLINE = "com.sun.xml.ws.policy.util.Trampoline";
    private static final Method bounce = MethodUtil.getTrampoline();
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final String PROXY_PACKAGE = "com.sun.proxy";

    private MethodUtil() {
    }

    public static Object invoke(Method m2, Object obj, Object[] params) throws InvocationTargetException, IllegalAccessException {
        try {
            return bounce.invoke(null, m2, obj, params);
        }
        catch (InvocationTargetException ie) {
            Throwable t = ie.getCause();
            if (t instanceof InvocationTargetException) {
                throw (InvocationTargetException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw (IllegalAccessException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error("Unexpected invocation error", t);
        }
        catch (IllegalAccessException iae) {
            throw new Error("Unexpected invocation error", iae);
        }
    }

    private static Method getTrampoline() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Class<?> t = MethodUtil.getTrampolineClass();
                    Method b2 = t.getDeclaredMethod("invoke", Method.class, Object.class, Object[].class);
                    b2.setAccessible(true);
                    return b2;
                }
            });
        }
        catch (Exception e2) {
            throw new InternalError("bouncer cannot be found", e2);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        MethodUtil.checkPackageAccess(name);
        Class<?> c2 = this.findLoadedClass(name);
        if (c2 == null) {
            try {
                c2 = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c2 == null) {
                c2 = this.getParent().loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c2);
        }
        return c2;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        block9: {
            if (!name.startsWith(WS_UTIL_POLICY_PKG)) {
                throw new ClassNotFoundException(name);
            }
            String path = "/".concat(name.replace('.', '/').concat(".class"));
            InputStream in = MethodUtil.class.getResourceAsStream(path);
            try {
                byte[] b2 = this.readAllBytes(in);
                clazz = this.defineClass(name, b2);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new ClassNotFoundException(name, e2);
                }
            }
            in.close();
        }
        return clazz;
    }

    private byte[] readAllBytes(InputStream in) throws IOException {
        byte[] buf = new byte[8192];
        int capacity = buf.length;
        int nread = 0;
        while (true) {
            int n;
            if ((n = in.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity <<= 1;
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    private Class<?> defineClass(String name, byte[] b2) throws IOException {
        CodeSource cs = new CodeSource(null, (Certificate[])null);
        if (!name.equals(TRAMPOLINE)) {
            throw new IOException("MethodUtil: bad name " + name);
        }
        return this.defineClass(name, b2, 0, b2.length, cs);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection perms = super.getPermissions(codesource);
        perms.add(new AllPermission());
        return perms;
    }

    private static Class<?> getTrampolineClass() {
        try {
            return Class.forName(TRAMPOLINE, true, new MethodUtil());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static void checkPackageAccess(String name) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            int i2;
            int b2;
            String cname = name.replace('/', '.');
            if (cname.startsWith("[") && (b2 = cname.lastIndexOf(91) + 2) > 1 && b2 < cname.length()) {
                cname = cname.substring(b2);
            }
            if ((i2 = cname.lastIndexOf(46)) != -1) {
                s.checkPackageAccess(cname.substring(0, i2));
            }
        }
    }

    private static void checkPackageAccess(Class<?> clazz) {
        MethodUtil.checkPackageAccess(clazz.getName());
        if (MethodUtil.isNonPublicProxyClass(clazz)) {
            MethodUtil.checkProxyPackageAccess(clazz);
        }
    }

    private static boolean isNonPublicProxyClass(Class<?> cls) {
        String name = cls.getName();
        int i2 = name.lastIndexOf(46);
        String pkg = i2 != -1 ? name.substring(0, i2) : "";
        return Proxy.isProxyClass(cls) && !pkg.startsWith(PROXY_PACKAGE);
    }

    private static void checkProxyPackageAccess(Class<?> clazz) {
        SecurityManager s = System.getSecurityManager();
        if (s != null && Proxy.isProxyClass(clazz)) {
            for (Class<?> intf : clazz.getInterfaces()) {
                MethodUtil.checkPackageAccess(intf);
            }
        }
    }
}

