/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.istack.NotNull;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;

public final class QNameMap<V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    transient Entry<V>[] table = new Entry[16];
    transient int size;
    private int threshold = 12;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Set<Entry<V>> entrySet = null;
    private transient Iterable<V> views = new Iterable<V>(){

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }
    };

    public QNameMap() {
        this.table = new Entry[16];
    }

    public void put(String namespaceUri, String localname, V value) {
        assert (localname != null);
        assert (namespaceUri != null);
        int hash = QNameMap.hash(localname);
        int i2 = QNameMap.indexFor(hash, this.table.length);
        Entry<V> e2 = this.table[i2];
        while (e2 != null) {
            if (e2.hash == hash && localname.equals(e2.localName) && namespaceUri.equals(e2.nsUri)) {
                e2.value = value;
                return;
            }
            e2 = e2.next;
        }
        this.addEntry(hash, namespaceUri, localname, value, i2);
    }

    public void put(QName name, V value) {
        this.put(name.getNamespaceURI(), name.getLocalPart(), value);
    }

    public V get(@NotNull String nsUri, String localPart) {
        Entry<V> e2 = this.getEntry(nsUri, localPart);
        if (e2 == null) {
            return null;
        }
        return e2.value;
    }

    public V get(QName name) {
        return this.get(name.getNamespaceURI(), name.getLocalPart());
    }

    public int size() {
        return this.size;
    }

    public QNameMap<V> putAll(QNameMap<? extends V> map) {
        int numKeysToBeAdded = map.size();
        if (numKeysToBeAdded == 0) {
            return this;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = numKeysToBeAdded;
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Entry<V> e2 : map.entrySet()) {
            this.put(e2.nsUri, e2.localName, e2.getValue());
        }
        return this;
    }

    public QNameMap<V> putAll(Map<QName, ? extends V> map) {
        for (Map.Entry<QName, V> e2 : map.entrySet()) {
            QName qn = e2.getKey();
            this.put(qn.getNamespaceURI(), qn.getLocalPart(), e2.getValue());
        }
        return this;
    }

    private static int hash(String x) {
        int h2 = x.hashCode();
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    private static int indexFor(int h2, int length) {
        return h2 & length - 1;
    }

    private void addEntry(int hash, String nsUri, String localName, V value, int bucketIndex) {
        Entry<V> e2 = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<V>(hash, nsUri, localName, value, e2);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private void resize(int newCapacity) {
        Entry<V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = newCapacity;
    }

    private void transfer(Entry<V>[] newTable) {
        Entry<V>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j2 = 0; j2 < src.length; ++j2) {
            Entry next;
            Entry<V> e2 = src[j2];
            if (e2 == null) continue;
            src[j2] = null;
            do {
                next = e2.next;
                int i2 = QNameMap.indexFor(e2.hash, newCapacity);
                e2.next = newTable[i2];
                newTable[i2] = e2;
            } while ((e2 = next) != null);
        }
    }

    public Entry<V> getOne() {
        for (Entry<V> e2 : this.table) {
            if (e2 == null) continue;
            return e2;
        }
        return null;
    }

    public Collection<QName> keySet() {
        HashSet<QName> r = new HashSet<QName>();
        for (Entry<V> e2 : this.entrySet()) {
            r.add(e2.createQName());
        }
        return r;
    }

    public Iterable<V> values() {
        return this.views;
    }

    public boolean containsKey(@NotNull String nsUri, String localName) {
        return this.getEntry(nsUri, localName) != null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set<Entry<V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private Iterator<Entry<V>> newEntryIterator() {
        return new EntryIterator();
    }

    private Entry<V> getEntry(@NotNull String nsUri, String localName) {
        int hash = QNameMap.hash(localName);
        int i2 = QNameMap.indexFor(hash, this.table.length);
        Entry<V> e2 = this.table[i2];
        while (!(e2 == null || localName.equals(e2.localName) && nsUri.equals(e2.nsUri))) {
            e2 = e2.next;
        }
        return e2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        for (Entry<V> e2 : this.entrySet()) {
            if (buf.length() > 1) {
                buf.append(',');
            }
            buf.append('[');
            buf.append(e2);
            buf.append(']');
        }
        buf.append('}');
        return buf.toString();
    }

    public static final class Entry<V> {
        public final String nsUri;
        public final String localName;
        V value;
        final int hash;
        Entry<V> next;

        Entry(int h2, String nsUri, String localName, V v, Entry<V> n) {
            this.value = v;
            this.next = n;
            this.nsUri = nsUri;
            this.localName = localName;
            this.hash = h2;
        }

        public QName createQName() {
            return new QName(this.nsUri, this.localName);
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e2 = (Entry)o;
            String k1 = this.nsUri;
            String k2 = e2.nsUri;
            String k3 = this.localName;
            String k4 = e2.localName;
            if (k1.equals(k2) && k3.equals(k4)) {
                V v2;
                V v1 = this.getValue();
                return v1 == (v2 = e2.getValue()) || v1 != null && v1.equals(v2);
            }
            return false;
        }

        public int hashCode() {
            return this.localName.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return "\"" + this.nsUri + "\",\"" + this.localName + "\"=" + this.getValue();
        }
    }

    private class EntrySet
    extends AbstractSet<Entry<V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return QNameMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e2 = (Entry)o;
            Entry candidate = QNameMap.this.getEntry(e2.nsUri, e2.localName);
            return candidate != null && candidate.equals(e2);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return QNameMap.this.size;
        }
    }

    private class EntryIterator
    extends HashIterator<Entry<V>> {
        private EntryIterator() {
        }

        @Override
        public Entry<V> next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<V> next;
        int index;

        HashIterator() {
            Entry<V>[] t = QNameMap.this.table;
            int i2 = t.length;
            Entry n = null;
            if (QNameMap.this.size != 0) {
                while (i2 > 0 && (n = t[--i2]) == null) {
                }
            }
            this.next = n;
            this.index = i2;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<V> nextEntry() {
            Entry e2 = this.next;
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            Entry n = e2.next;
            Entry<V>[] t = QNameMap.this.table;
            int i2 = this.index;
            while (n == null && i2 > 0) {
                n = t[--i2];
            }
            this.index = i2;
            this.next = n;
            return e2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

