/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.CommandObject;
import jakarta.activation.DataHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class CommandInfo {
    private String verb;
    private String className;

    public CommandInfo(String verb, String className) {
        this.verb = verb;
        this.className = className;
    }

    public String getCommandName() {
        return this.verb;
    }

    public String getCommandClass() {
        return this.className;
    }

    public Object getCommandObject(DataHandler dh, ClassLoader loader) throws IOException, ClassNotFoundException {
        Object new_bean = null;
        new_bean = Beans.instantiate(loader, this.className);
        if (new_bean != null) {
            InputStream is;
            if (new_bean instanceof CommandObject) {
                ((CommandObject)new_bean).setCommandContext(this.verb, dh);
            } else if (new_bean instanceof Externalizable && dh != null && (is = dh.getInputStream()) != null) {
                ((Externalizable)new_bean).readExternal(new ObjectInputStream(is));
            }
        }
        return new_bean;
    }

    private static final class Beans {
        static final Method instantiateMethod;

        private Beans() {
        }

        static Object instantiate(ClassLoader loader, String cn) throws IOException, ClassNotFoundException {
            if (instantiateMethod != null) {
                try {
                    return instantiateMethod.invoke(null, loader, cn);
                }
                catch (IllegalAccessException | InvocationTargetException e2) {
                    ReflectiveOperationException exception = e2;
                }
            } else {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    int i2;
                    int b2;
                    String cname = cn.replace('/', '.');
                    if (cname.startsWith("[") && (b2 = cname.lastIndexOf(91) + 2) > 1 && b2 < cname.length()) {
                        cname = cname.substring(b2);
                    }
                    if ((i2 = cname.lastIndexOf(46)) != -1) {
                        security.checkPackageAccess(cname.substring(0, i2));
                    }
                }
                if (loader == null) {
                    loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            ClassLoader cl = null;
                            try {
                                cl = ClassLoader.getSystemClassLoader();
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                            return cl;
                        }
                    });
                }
                Class<?> beanClass = Class.forName(cn, true, loader);
                try {
                    return beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    throw new ClassNotFoundException(beanClass + ": " + ex, ex);
                }
            }
            return null;
        }

        static {
            Method m2;
            try {
                Class<?> c2 = Class.forName("java.beans.Beans");
                m2 = c2.getDeclaredMethod("instantiate", ClassLoader.class, String.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e2) {
                m2 = null;
            }
            instantiateMethod = m2;
        }
    }
}

