/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.altindag.ssl.exception.GenericIOException;
import nl.altindag.ssl.util.CertificateUtils;
import nl.altindag.ssl.util.KeyStoreUtils;
import nl.altindag.ssl.util.OSCertificateUtils;
import nl.altindag.ssl.util.internal.CollectionUtils;
import nl.altindag.ssl.util.internal.CollectorsUtils;
import nl.altindag.ssl.util.internal.IOUtils;

final class MacCertificateUtils
extends OSCertificateUtils {
    private static MacCertificateUtils INSTANCE;
    private static final String SECURITY_EXECUTABLE = "security";
    private static final String SYSTEM_ROOT_KEYCHAIN_FILE = "/System/Library/Keychains/SystemRootCertificates.keychain";
    private static final List<String> KEYCHAIN_LOOKUP_COMMANDS;
    private static final List<Path> MAC_CERTIFICATE_PATHS;
    private static final Map<String, Path> MAC_CERTIFICATE_PATHS_TO_RESOLVE;
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String DOUBLE_QUOTES = "\"";

    private MacCertificateUtils() {
    }

    @Override
    List<KeyStore> getTrustStores() {
        ArrayList<KeyStore> keyStores = new ArrayList<KeyStore>();
        this.createKeyStoreIfAvailable("KeychainStore", null).ifPresent(keyStores::add);
        List<Certificate> systemTrustedCertificates = this.getCertificates();
        if (!systemTrustedCertificates.isEmpty()) {
            KeyStore systemTrustStore = KeyStoreUtils.createTrustStore(systemTrustedCertificates);
            keyStores.add(systemTrustStore);
        }
        return keyStores;
    }

    List<Certificate> getCertificates() {
        String certificateContent = this.getKeychainFiles().stream().distinct().map(MacCertificateUtils::createProcessForGettingCertificates).map(Process::getInputStream).map(IOUtils::getContent).collect(Collectors.joining(System.lineSeparator()));
        List<Certificate> certificatesFromKeyChains = CertificateUtils.parsePemCertificate(certificateContent);
        List certificateFromResolvedPaths = MAC_CERTIFICATE_PATHS_TO_RESOLVE.entrySet().stream().flatMap(entry -> this.findPathsWithSamePrefix((String)entry.getKey(), (Path)entry.getValue()).stream()).collect(CollectorsUtils.toListAndThen(this::getCertificates));
        List<Certificate> certificatesFromPredefinedPaths = this.getCertificates(MAC_CERTIFICATE_PATHS);
        return Stream.of(certificatesFromKeyChains, certificateFromResolvedPaths, certificatesFromPredefinedPaths).flatMap(Collection::stream).distinct().collect(CollectorsUtils.toUnmodifiableList());
    }

    List<String> getKeychainFiles() {
        ArrayList<String> keychainFiles = new ArrayList<String>();
        keychainFiles.add(SYSTEM_ROOT_KEYCHAIN_FILE);
        KEYCHAIN_LOOKUP_COMMANDS.stream().map(MacCertificateUtils::createProcessForGettingKeychainFile).map(Process::getInputStream).map(IOUtils::getContent).flatMap(content -> Stream.of(content.split(System.lineSeparator())).map(line -> line.replace(DOUBLE_QUOTES, EMPTY)).map(String::trim)).filter(keyChainFile -> !keyChainFile.endsWith("login.keychain-db")).forEach(keychainFiles::add);
        return keychainFiles;
    }

    private static Process createProcessForGettingKeychainFile(String command) {
        return MacCertificateUtils.createProcess("security " + command);
    }

    private static Process createProcessForGettingCertificates(String keychainFilePath) {
        String command = String.format("%s find-certificate -a -p %s", SECURITY_EXECUTABLE, keychainFilePath);
        return MacCertificateUtils.createProcess(command);
    }

    private static Process createProcess(String command) {
        try {
            return Runtime.getRuntime().exec(command);
        }
        catch (IOException e2) {
            throw new GenericIOException(e2);
        }
    }

    static MacCertificateUtils getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MacCertificateUtils();
        }
        return INSTANCE;
    }

    static {
        KEYCHAIN_LOOKUP_COMMANDS = CollectionUtils.toUnmodifiableList("list-keychains", "default-keychain");
        MAC_CERTIFICATE_PATHS = Stream.of("/etc/ssl/certs", "/usr/local/etc/ca-certificates", "/usr/local/share/ca-certificates").map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        MAC_CERTIFICATE_PATHS_TO_RESOLVE = Collections.singletonMap("openssl", Paths.get("/usr/local/etc", new String[0]));
    }
}

